/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest;
import software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsResponse;
import software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutput;

public class ListTimeSeriesDataPointsPublisher
implements SdkPublisher<ListTimeSeriesDataPointsResponse> {
    private final DataZoneAsyncClient client;
    private final ListTimeSeriesDataPointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTimeSeriesDataPointsPublisher(DataZoneAsyncClient client, ListTimeSeriesDataPointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTimeSeriesDataPointsPublisher(DataZoneAsyncClient client, ListTimeSeriesDataPointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTimeSeriesDataPointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTimeSeriesDataPointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TimeSeriesDataPointSummaryFormOutput> items() {
        Function<ListTimeSeriesDataPointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTimeSeriesDataPointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTimeSeriesDataPointsResponseFetcher
    implements AsyncPageFetcher<ListTimeSeriesDataPointsResponse> {
        private ListTimeSeriesDataPointsResponseFetcher() {
        }

        public boolean hasNextPage(ListTimeSeriesDataPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTimeSeriesDataPointsResponse> nextPage(ListTimeSeriesDataPointsResponse previousPage) {
            if (previousPage == null) {
                return ListTimeSeriesDataPointsPublisher.this.client.listTimeSeriesDataPoints(ListTimeSeriesDataPointsPublisher.this.firstRequest);
            }
            return ListTimeSeriesDataPointsPublisher.this.client.listTimeSeriesDataPoints((ListTimeSeriesDataPointsRequest)((Object)ListTimeSeriesDataPointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

