/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FormInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FormInput> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("content").getter(FormInput.getter(FormInput::content)).setter(FormInput.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> FORM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("formName").getter(FormInput.getter(FormInput::formName)).setter(FormInput.setter(Builder::formName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formName").build()}).build();
    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeIdentifier").getter(FormInput.getter(FormInput::typeIdentifier)).setter(FormInput.setter(Builder::typeIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeIdentifier").build()}).build();
    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeRevision").getter(FormInput.getter(FormInput::typeRevision)).setter(FormInput.setter(Builder::typeRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, FORM_NAME_FIELD, TYPE_IDENTIFIER_FIELD, TYPE_REVISION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String content;
    private final String formName;
    private final String typeIdentifier;
    private final String typeRevision;

    private FormInput(BuilderImpl builder) {
        this.content = builder.content;
        this.formName = builder.formName;
        this.typeIdentifier = builder.typeIdentifier;
        this.typeRevision = builder.typeRevision;
    }

    public final String content() {
        return this.content;
    }

    public final String formName() {
        return this.formName;
    }

    public final String typeIdentifier() {
        return this.typeIdentifier;
    }

    public final String typeRevision() {
        return this.typeRevision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.formName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeRevision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormInput)) {
            return false;
        }
        FormInput other = (FormInput)obj;
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.formName(), other.formName()) && Objects.equals(this.typeIdentifier(), other.typeIdentifier()) && Objects.equals(this.typeRevision(), other.typeRevision());
    }

    public final String toString() {
        return ToString.builder((String)"FormInput").add("Content", (Object)this.content()).add("FormName", (Object)this.formName()).add("TypeIdentifier", (Object)this.typeIdentifier()).add("TypeRevision", (Object)this.typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "formName": {
                return Optional.ofNullable(clazz.cast(this.formName()));
            }
            case "typeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.typeIdentifier()));
            }
            case "typeRevision": {
                return Optional.ofNullable(clazz.cast(this.typeRevision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FormInput, T> g) {
        return obj -> g.apply((FormInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String content;
        private String formName;
        private String typeIdentifier;
        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(FormInput model) {
            this.content(model.content);
            this.formName(model.formName);
            this.typeIdentifier(model.typeIdentifier);
            this.typeRevision(model.typeRevision);
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getFormName() {
            return this.formName;
        }

        public final void setFormName(String formName) {
            this.formName = formName;
        }

        @Override
        public final Builder formName(String formName) {
            this.formName = formName;
            return this;
        }

        public final String getTypeIdentifier() {
            return this.typeIdentifier;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        public final String getTypeRevision() {
            return this.typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        public FormInput build() {
            return new FormInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FormInput> {
        public Builder content(String var1);

        public Builder formName(String var1);

        public Builder typeIdentifier(String var1);

        public Builder typeRevision(String var1);
    }
}

