/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DomainStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DomainSummary.getter(DomainSummary::arn)).setter(DomainSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DomainSummary.getter(DomainSummary::createdAt)).setter(DomainSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DomainSummary.getter(DomainSummary::description)).setter(DomainSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DomainSummary.getter(DomainSummary::id)).setter(DomainSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(DomainSummary.getter(DomainSummary::lastUpdatedAt)).setter(DomainSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> MANAGED_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedAccountId").getter(DomainSummary.getter(DomainSummary::managedAccountId)).setter(DomainSummary.setter(Builder::managedAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedAccountId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DomainSummary.getter(DomainSummary::name)).setter(DomainSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PORTAL_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalUrl").getter(DomainSummary.getter(DomainSummary::portalUrl)).setter(DomainSummary.setter(Builder::portalUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalUrl").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DomainSummary.getter(DomainSummary::statusAsString)).setter(DomainSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, MANAGED_ACCOUNT_ID_FIELD, NAME_FIELD, PORTAL_URL_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdAt;
    private final String description;
    private final String id;
    private final Instant lastUpdatedAt;
    private final String managedAccountId;
    private final String name;
    private final String portalUrl;
    private final String status;

    private DomainSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.managedAccountId = builder.managedAccountId;
        this.name = builder.name;
        this.portalUrl = builder.portalUrl;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String managedAccountId() {
        return this.managedAccountId;
    }

    public final String name() {
        return this.name;
    }

    public final String portalUrl() {
        return this.portalUrl;
    }

    public final DomainStatus status() {
        return DomainStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSummary)) {
            return false;
        }
        DomainSummary other = (DomainSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.managedAccountId(), other.managedAccountId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.portalUrl(), other.portalUrl()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DomainSummary").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Id", (Object)this.id()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("ManagedAccountId", (Object)this.managedAccountId()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("PortalUrl", (Object)this.portalUrl()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "managedAccountId": {
                return Optional.ofNullable(clazz.cast(this.managedAccountId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "portalUrl": {
                return Optional.ofNullable(clazz.cast(this.portalUrl()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainSummary, T> g) {
        return obj -> g.apply((DomainSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String description;
        private String id;
        private Instant lastUpdatedAt;
        private String managedAccountId;
        private String name;
        private String portalUrl;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSummary model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.managedAccountId(model.managedAccountId);
            this.name(model.name);
            this.portalUrl(model.portalUrl);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getManagedAccountId() {
            return this.managedAccountId;
        }

        public final void setManagedAccountId(String managedAccountId) {
            this.managedAccountId = managedAccountId;
        }

        @Override
        public final Builder managedAccountId(String managedAccountId) {
            this.managedAccountId = managedAccountId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPortalUrl() {
            return this.portalUrl;
        }

        public final void setPortalUrl(String portalUrl) {
            this.portalUrl = portalUrl;
        }

        @Override
        public final Builder portalUrl(String portalUrl) {
            this.portalUrl = portalUrl;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public DomainSummary build() {
            return new DomainSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainSummary> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder managedAccountId(String var1);

        public Builder name(String var1);

        public Builder portalUrl(String var1);

        public Builder status(String var1);

        public Builder status(DomainStatus var1);
    }
}

