/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AcceptChoice;
import software.amazon.awssdk.services.datazone.model.AcceptChoicesCopier;
import software.amazon.awssdk.services.datazone.model.AcceptRule;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptPredictionsRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, AcceptPredictionsRequest> {
    private static final SdkField<List<AcceptChoice>> ACCEPT_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("acceptChoices").getter(AcceptPredictionsRequest.getter(AcceptPredictionsRequest::acceptChoices)).setter(AcceptPredictionsRequest.setter(Builder::acceptChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptChoices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AcceptChoice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AcceptRule> ACCEPT_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("acceptRule").getter(AcceptPredictionsRequest.getter(AcceptPredictionsRequest::acceptRule)).setter(AcceptPredictionsRequest.setter(Builder::acceptRule)).constructor(AcceptRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptRule").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(AcceptPredictionsRequest.getter(AcceptPredictionsRequest::clientToken)).setter(AcceptPredictionsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(AcceptPredictionsRequest.getter(AcceptPredictionsRequest::domainIdentifier)).setter(AcceptPredictionsRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(AcceptPredictionsRequest.getter(AcceptPredictionsRequest::identifier)).setter(AcceptPredictionsRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revision").getter(AcceptPredictionsRequest.getter(AcceptPredictionsRequest::revision)).setter(AcceptPredictionsRequest.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("revision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_CHOICES_FIELD, ACCEPT_RULE_FIELD, CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD, REVISION_FIELD));
    private final List<AcceptChoice> acceptChoices;
    private final AcceptRule acceptRule;
    private final String clientToken;
    private final String domainIdentifier;
    private final String identifier;
    private final String revision;

    private AcceptPredictionsRequest(BuilderImpl builder) {
        super(builder);
        this.acceptChoices = builder.acceptChoices;
        this.acceptRule = builder.acceptRule;
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.revision = builder.revision;
    }

    public final boolean hasAcceptChoices() {
        return this.acceptChoices != null && !(this.acceptChoices instanceof SdkAutoConstructList);
    }

    public final List<AcceptChoice> acceptChoices() {
        return this.acceptChoices;
    }

    public final AcceptRule acceptRule() {
        return this.acceptRule;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String revision() {
        return this.revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceptChoices() ? this.acceptChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptPredictionsRequest)) {
            return false;
        }
        AcceptPredictionsRequest other = (AcceptPredictionsRequest)((Object)obj);
        return this.hasAcceptChoices() == other.hasAcceptChoices() && Objects.equals(this.acceptChoices(), other.acceptChoices()) && Objects.equals(this.acceptRule(), other.acceptRule()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.revision(), other.revision());
    }

    public final String toString() {
        return ToString.builder((String)"AcceptPredictionsRequest").add("AcceptChoices", this.hasAcceptChoices() ? this.acceptChoices() : null).add("AcceptRule", (Object)this.acceptRule()).add("ClientToken", (Object)this.clientToken()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("Identifier", (Object)this.identifier()).add("Revision", (Object)this.revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acceptChoices": {
                return Optional.ofNullable(clazz.cast(this.acceptChoices()));
            }
            case "acceptRule": {
                return Optional.ofNullable(clazz.cast(this.acceptRule()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptPredictionsRequest, T> g) {
        return obj -> g.apply((AcceptPredictionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private List<AcceptChoice> acceptChoices = DefaultSdkAutoConstructList.getInstance();
        private AcceptRule acceptRule;
        private String clientToken;
        private String domainIdentifier;
        private String identifier;
        private String revision;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptPredictionsRequest model) {
            super(model);
            this.acceptChoices(model.acceptChoices);
            this.acceptRule(model.acceptRule);
            this.clientToken(model.clientToken);
            this.domainIdentifier(model.domainIdentifier);
            this.identifier(model.identifier);
            this.revision(model.revision);
        }

        public final List<AcceptChoice.Builder> getAcceptChoices() {
            List<AcceptChoice.Builder> result = AcceptChoicesCopier.copyToBuilder(this.acceptChoices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAcceptChoices(Collection<AcceptChoice.BuilderImpl> acceptChoices) {
            this.acceptChoices = AcceptChoicesCopier.copyFromBuilder(acceptChoices);
        }

        @Override
        public final Builder acceptChoices(Collection<AcceptChoice> acceptChoices) {
            this.acceptChoices = AcceptChoicesCopier.copy(acceptChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptChoices(AcceptChoice ... acceptChoices) {
            this.acceptChoices(Arrays.asList(acceptChoices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptChoices(Consumer<AcceptChoice.Builder> ... acceptChoices) {
            this.acceptChoices(Stream.of(acceptChoices).map(c -> (AcceptChoice)((AcceptChoice.Builder)AcceptChoice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AcceptRule.Builder getAcceptRule() {
            return this.acceptRule != null ? this.acceptRule.toBuilder() : null;
        }

        public final void setAcceptRule(AcceptRule.BuilderImpl acceptRule) {
            this.acceptRule = acceptRule != null ? acceptRule.build() : null;
        }

        @Override
        public final Builder acceptRule(AcceptRule acceptRule) {
            this.acceptRule = acceptRule;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptPredictionsRequest build() {
            return new AcceptPredictionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcceptPredictionsRequest> {
        public Builder acceptChoices(Collection<AcceptChoice> var1);

        public Builder acceptChoices(AcceptChoice ... var1);

        public Builder acceptChoices(Consumer<AcceptChoice.Builder> ... var1);

        public Builder acceptRule(AcceptRule var1);

        default public Builder acceptRule(Consumer<AcceptRule.Builder> acceptRule) {
            return this.acceptRule((AcceptRule)((AcceptRule.Builder)AcceptRule.builder().applyMutation(acceptRule)).build());
        }

        public Builder clientToken(String var1);

        public Builder domainIdentifier(String var1);

        public Builder identifier(String var1);

        public Builder revision(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

