/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FormEntryOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FormEntryOutput> {
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("required").getter(FormEntryOutput.getter(FormEntryOutput::required)).setter(FormEntryOutput.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeName").getter(FormEntryOutput.getter(FormEntryOutput::typeName)).setter(FormEntryOutput.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()}).build();
    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeRevision").getter(FormEntryOutput.getter(FormEntryOutput::typeRevision)).setter(FormEntryOutput.setter(Builder::typeRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUIRED_FIELD, TYPE_NAME_FIELD, TYPE_REVISION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean required;
    private final String typeName;
    private final String typeRevision;

    private FormEntryOutput(BuilderImpl builder) {
        this.required = builder.required;
        this.typeName = builder.typeName;
        this.typeRevision = builder.typeRevision;
    }

    public final Boolean required() {
        return this.required;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String typeRevision() {
        return this.typeRevision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeRevision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormEntryOutput)) {
            return false;
        }
        FormEntryOutput other = (FormEntryOutput)obj;
        return Objects.equals(this.required(), other.required()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.typeRevision(), other.typeRevision());
    }

    public final String toString() {
        return ToString.builder((String)"FormEntryOutput").add("Required", (Object)this.required()).add("TypeName", (Object)(this.typeName() == null ? null : "*** Sensitive Data Redacted ***")).add("TypeRevision", (Object)this.typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
            case "typeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "typeRevision": {
                return Optional.ofNullable(clazz.cast(this.typeRevision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FormEntryOutput, T> g) {
        return obj -> g.apply((FormEntryOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean required;
        private String typeName;
        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(FormEntryOutput model) {
            this.required(model.required);
            this.typeName(model.typeName);
            this.typeRevision(model.typeRevision);
        }

        public final Boolean getRequired() {
            return this.required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeRevision() {
            return this.typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        public FormEntryOutput build() {
            return new FormEntryOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FormEntryOutput> {
        public Builder required(Boolean var1);

        public Builder typeName(String var1);

        public Builder typeRevision(String var1);
    }
}

