/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.NfsMountOptions;
import software.amazon.awssdk.services.datasync.model.OnPremConfig;
import software.amazon.awssdk.services.datasync.model.TagListCopier;
import software.amazon.awssdk.services.datasync.model.TagListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLocationNfsRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, CreateLocationNfsRequest> {
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLocationNfsRequest.getter(CreateLocationNfsRequest::subdirectory)).setter(CreateLocationNfsRequest.setter(Builder::subdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()}).build();
    private static final SdkField<String> SERVER_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLocationNfsRequest.getter(CreateLocationNfsRequest::serverHostname)).setter(CreateLocationNfsRequest.setter(Builder::serverHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerHostname").build()}).build();
    private static final SdkField<OnPremConfig> ON_PREM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateLocationNfsRequest.getter(CreateLocationNfsRequest::onPremConfig)).setter(CreateLocationNfsRequest.setter(Builder::onPremConfig)).constructor(OnPremConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPremConfig").build()}).build();
    private static final SdkField<NfsMountOptions> MOUNT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateLocationNfsRequest.getter(CreateLocationNfsRequest::mountOptions)).setter(CreateLocationNfsRequest.setter(Builder::mountOptions)).constructor(NfsMountOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()}).build();
    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateLocationNfsRequest.getter(CreateLocationNfsRequest::tags)).setter(CreateLocationNfsRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBDIRECTORY_FIELD, SERVER_HOSTNAME_FIELD, ON_PREM_CONFIG_FIELD, MOUNT_OPTIONS_FIELD, TAGS_FIELD));
    private final String subdirectory;
    private final String serverHostname;
    private final OnPremConfig onPremConfig;
    private final NfsMountOptions mountOptions;
    private final List<TagListEntry> tags;

    private CreateLocationNfsRequest(BuilderImpl builder) {
        super(builder);
        this.subdirectory = builder.subdirectory;
        this.serverHostname = builder.serverHostname;
        this.onPremConfig = builder.onPremConfig;
        this.mountOptions = builder.mountOptions;
        this.tags = builder.tags;
    }

    public String subdirectory() {
        return this.subdirectory;
    }

    public String serverHostname() {
        return this.serverHostname;
    }

    public OnPremConfig onPremConfig() {
        return this.onPremConfig;
    }

    public NfsMountOptions mountOptions() {
        return this.mountOptions;
    }

    public List<TagListEntry> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.onPremConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationNfsRequest)) {
            return false;
        }
        CreateLocationNfsRequest other = (CreateLocationNfsRequest)((Object)obj);
        return Objects.equals(this.subdirectory(), other.subdirectory()) && Objects.equals(this.serverHostname(), other.serverHostname()) && Objects.equals(this.onPremConfig(), other.onPremConfig()) && Objects.equals(this.mountOptions(), other.mountOptions()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateLocationNfsRequest").add("Subdirectory", (Object)this.subdirectory()).add("ServerHostname", (Object)this.serverHostname()).add("OnPremConfig", (Object)this.onPremConfig()).add("MountOptions", (Object)this.mountOptions()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subdirectory": {
                return Optional.ofNullable(clazz.cast(this.subdirectory()));
            }
            case "ServerHostname": {
                return Optional.ofNullable(clazz.cast(this.serverHostname()));
            }
            case "OnPremConfig": {
                return Optional.ofNullable(clazz.cast(this.onPremConfig()));
            }
            case "MountOptions": {
                return Optional.ofNullable(clazz.cast(this.mountOptions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationNfsRequest, T> g) {
        return obj -> g.apply((CreateLocationNfsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String subdirectory;
        private String serverHostname;
        private OnPremConfig onPremConfig;
        private NfsMountOptions mountOptions;
        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationNfsRequest model) {
            super(model);
            this.subdirectory(model.subdirectory);
            this.serverHostname(model.serverHostname);
            this.onPremConfig(model.onPremConfig);
            this.mountOptions(model.mountOptions);
            this.tags(model.tags);
        }

        public final String getSubdirectory() {
            return this.subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        public final String getServerHostname() {
            return this.serverHostname;
        }

        @Override
        public final Builder serverHostname(String serverHostname) {
            this.serverHostname = serverHostname;
            return this;
        }

        public final void setServerHostname(String serverHostname) {
            this.serverHostname = serverHostname;
        }

        public final OnPremConfig.Builder getOnPremConfig() {
            return this.onPremConfig != null ? this.onPremConfig.toBuilder() : null;
        }

        @Override
        public final Builder onPremConfig(OnPremConfig onPremConfig) {
            this.onPremConfig = onPremConfig;
            return this;
        }

        public final void setOnPremConfig(OnPremConfig.BuilderImpl onPremConfig) {
            this.onPremConfig = onPremConfig != null ? onPremConfig.build() : null;
        }

        public final NfsMountOptions.Builder getMountOptions() {
            return this.mountOptions != null ? this.mountOptions.toBuilder() : null;
        }

        @Override
        public final Builder mountOptions(NfsMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        public final void setMountOptions(NfsMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        public final Collection<TagListEntry.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(TagListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagListEntry)((TagListEntry.Builder)TagListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocationNfsRequest build() {
            return new CreateLocationNfsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLocationNfsRequest> {
        public Builder subdirectory(String var1);

        public Builder serverHostname(String var1);

        public Builder onPremConfig(OnPremConfig var1);

        default public Builder onPremConfig(Consumer<OnPremConfig.Builder> onPremConfig) {
            return this.onPremConfig((OnPremConfig)((OnPremConfig.Builder)OnPremConfig.builder().applyMutation(onPremConfig)).build());
        }

        public Builder mountOptions(NfsMountOptions var1);

        default public Builder mountOptions(Consumer<NfsMountOptions.Builder> mountOptions) {
            return this.mountOptions((NfsMountOptions)((NfsMountOptions.Builder)NfsMountOptions.builder().applyMutation(mountOptions)).build());
        }

        public Builder tags(Collection<TagListEntry> var1);

        public Builder tags(TagListEntry ... var1);

        public Builder tags(Consumer<TagListEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

