/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about your DataSync <a
 * href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">task schedule</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskScheduleDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskScheduleDetails.Builder, TaskScheduleDetails> {
    private static final SdkField<Instant> STATUS_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StatusUpdateTime").getter(getter(TaskScheduleDetails::statusUpdateTime))
            .setter(setter(Builder::statusUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusUpdateTime").build()).build();

    private static final SdkField<String> DISABLED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisabledReason").getter(getter(TaskScheduleDetails::disabledReason))
            .setter(setter(Builder::disabledReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledReason").build()).build();

    private static final SdkField<String> DISABLED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisabledBy").getter(getter(TaskScheduleDetails::disabledByAsString)).setter(setter(Builder::disabledBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_UPDATE_TIME_FIELD,
            DISABLED_REASON_FIELD, DISABLED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant statusUpdateTime;

    private final String disabledReason;

    private final String disabledBy;

    private TaskScheduleDetails(BuilderImpl builder) {
        this.statusUpdateTime = builder.statusUpdateTime;
        this.disabledReason = builder.disabledReason;
        this.disabledBy = builder.disabledBy;
    }

    /**
     * <p>
     * Indicates the last time the status of your task schedule changed. For example, if DataSync automatically disables
     * your schedule because of a repeated error, you can see when the schedule was disabled.
     * </p>
     * 
     * @return Indicates the last time the status of your task schedule changed. For example, if DataSync automatically
     *         disables your schedule because of a repeated error, you can see when the schedule was disabled.
     */
    public final Instant statusUpdateTime() {
        return statusUpdateTime;
    }

    /**
     * <p>
     * Provides a reason if the task schedule is disabled.
     * </p>
     * <p>
     * If your schedule is disabled by <code>USER</code>, you see a <code>Manually disabled by user.</code> message.
     * </p>
     * <p>
     * If your schedule is disabled by <code>SERVICE</code>, you see an error message to help you understand why the
     * task keeps failing. For information on resolving DataSync errors, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html"
     * >Troubleshooting issues with DataSync transfers</a>.
     * </p>
     * 
     * @return Provides a reason if the task schedule is disabled.</p>
     *         <p>
     *         If your schedule is disabled by <code>USER</code>, you see a <code>Manually disabled by user.</code>
     *         message.
     *         </p>
     *         <p>
     *         If your schedule is disabled by <code>SERVICE</code>, you see an error message to help you understand why
     *         the task keeps failing. For information on resolving DataSync errors, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html"
     *         >Troubleshooting issues with DataSync transfers</a>.
     */
    public final String disabledReason() {
        return disabledReason;
    }

    /**
     * <p>
     * Indicates how your task schedule was disabled.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>USER</code> - Your schedule was manually disabled by using the <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_UpdateTask.html">UpdateTask</a> operation or
     * DataSync console.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE</code> - Your schedule was automatically disabled by DataSync because the task failed repeatedly
     * with the same error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #disabledBy} will
     * return {@link ScheduleDisabledBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #disabledByAsString}.
     * </p>
     * 
     * @return Indicates how your task schedule was disabled.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>USER</code> - Your schedule was manually disabled by using the <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/API_UpdateTask.html">UpdateTask</a> operation
     *         or DataSync console.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVICE</code> - Your schedule was automatically disabled by DataSync because the task failed
     *         repeatedly with the same error.
     *         </p>
     *         </li>
     * @see ScheduleDisabledBy
     */
    public final ScheduleDisabledBy disabledBy() {
        return ScheduleDisabledBy.fromValue(disabledBy);
    }

    /**
     * <p>
     * Indicates how your task schedule was disabled.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>USER</code> - Your schedule was manually disabled by using the <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_UpdateTask.html">UpdateTask</a> operation or
     * DataSync console.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE</code> - Your schedule was automatically disabled by DataSync because the task failed repeatedly
     * with the same error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #disabledBy} will
     * return {@link ScheduleDisabledBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #disabledByAsString}.
     * </p>
     * 
     * @return Indicates how your task schedule was disabled.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>USER</code> - Your schedule was manually disabled by using the <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/API_UpdateTask.html">UpdateTask</a> operation
     *         or DataSync console.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVICE</code> - Your schedule was automatically disabled by DataSync because the task failed
     *         repeatedly with the same error.
     *         </p>
     *         </li>
     * @see ScheduleDisabledBy
     */
    public final String disabledByAsString() {
        return disabledBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(disabledReason());
        hashCode = 31 * hashCode + Objects.hashCode(disabledByAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskScheduleDetails)) {
            return false;
        }
        TaskScheduleDetails other = (TaskScheduleDetails) obj;
        return Objects.equals(statusUpdateTime(), other.statusUpdateTime())
                && Objects.equals(disabledReason(), other.disabledReason())
                && Objects.equals(disabledByAsString(), other.disabledByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskScheduleDetails").add("StatusUpdateTime", statusUpdateTime())
                .add("DisabledReason", disabledReason()).add("DisabledBy", disabledByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusUpdateTime":
            return Optional.ofNullable(clazz.cast(statusUpdateTime()));
        case "DisabledReason":
            return Optional.ofNullable(clazz.cast(disabledReason()));
        case "DisabledBy":
            return Optional.ofNullable(clazz.cast(disabledByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StatusUpdateTime", STATUS_UPDATE_TIME_FIELD);
        map.put("DisabledReason", DISABLED_REASON_FIELD);
        map.put("DisabledBy", DISABLED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskScheduleDetails, T> g) {
        return obj -> g.apply((TaskScheduleDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskScheduleDetails> {
        /**
         * <p>
         * Indicates the last time the status of your task schedule changed. For example, if DataSync automatically
         * disables your schedule because of a repeated error, you can see when the schedule was disabled.
         * </p>
         * 
         * @param statusUpdateTime
         *        Indicates the last time the status of your task schedule changed. For example, if DataSync
         *        automatically disables your schedule because of a repeated error, you can see when the schedule was
         *        disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusUpdateTime(Instant statusUpdateTime);

        /**
         * <p>
         * Provides a reason if the task schedule is disabled.
         * </p>
         * <p>
         * If your schedule is disabled by <code>USER</code>, you see a <code>Manually disabled by user.</code> message.
         * </p>
         * <p>
         * If your schedule is disabled by <code>SERVICE</code>, you see an error message to help you understand why the
         * task keeps failing. For information on resolving DataSync errors, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html"
         * >Troubleshooting issues with DataSync transfers</a>.
         * </p>
         * 
         * @param disabledReason
         *        Provides a reason if the task schedule is disabled.</p>
         *        <p>
         *        If your schedule is disabled by <code>USER</code>, you see a <code>Manually disabled by user.</code>
         *        message.
         *        </p>
         *        <p>
         *        If your schedule is disabled by <code>SERVICE</code>, you see an error message to help you understand
         *        why the task keeps failing. For information on resolving DataSync errors, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html"
         *        >Troubleshooting issues with DataSync transfers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledReason(String disabledReason);

        /**
         * <p>
         * Indicates how your task schedule was disabled.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>USER</code> - Your schedule was manually disabled by using the <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_UpdateTask.html">UpdateTask</a> operation or
         * DataSync console.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICE</code> - Your schedule was automatically disabled by DataSync because the task failed
         * repeatedly with the same error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param disabledBy
         *        Indicates how your task schedule was disabled.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>USER</code> - Your schedule was manually disabled by using the <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/API_UpdateTask.html">UpdateTask</a>
         *        operation or DataSync console.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVICE</code> - Your schedule was automatically disabled by DataSync because the task failed
         *        repeatedly with the same error.
         *        </p>
         *        </li>
         * @see ScheduleDisabledBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleDisabledBy
         */
        Builder disabledBy(String disabledBy);

        /**
         * <p>
         * Indicates how your task schedule was disabled.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>USER</code> - Your schedule was manually disabled by using the <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_UpdateTask.html">UpdateTask</a> operation or
         * DataSync console.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICE</code> - Your schedule was automatically disabled by DataSync because the task failed
         * repeatedly with the same error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param disabledBy
         *        Indicates how your task schedule was disabled.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>USER</code> - Your schedule was manually disabled by using the <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/API_UpdateTask.html">UpdateTask</a>
         *        operation or DataSync console.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVICE</code> - Your schedule was automatically disabled by DataSync because the task failed
         *        repeatedly with the same error.
         *        </p>
         *        </li>
         * @see ScheduleDisabledBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleDisabledBy
         */
        Builder disabledBy(ScheduleDisabledBy disabledBy);
    }

    static final class BuilderImpl implements Builder {
        private Instant statusUpdateTime;

        private String disabledReason;

        private String disabledBy;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskScheduleDetails model) {
            statusUpdateTime(model.statusUpdateTime);
            disabledReason(model.disabledReason);
            disabledBy(model.disabledBy);
        }

        public final Instant getStatusUpdateTime() {
            return statusUpdateTime;
        }

        public final void setStatusUpdateTime(Instant statusUpdateTime) {
            this.statusUpdateTime = statusUpdateTime;
        }

        @Override
        public final Builder statusUpdateTime(Instant statusUpdateTime) {
            this.statusUpdateTime = statusUpdateTime;
            return this;
        }

        public final String getDisabledReason() {
            return disabledReason;
        }

        public final void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Override
        public final Builder disabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
            return this;
        }

        public final String getDisabledBy() {
            return disabledBy;
        }

        public final void setDisabledBy(String disabledBy) {
            this.disabledBy = disabledBy;
        }

        @Override
        public final Builder disabledBy(String disabledBy) {
            this.disabledBy = disabledBy;
            return this;
        }

        @Override
        public final Builder disabledBy(ScheduleDisabledBy disabledBy) {
            this.disabledBy(disabledBy == null ? null : disabledBy.toString());
            return this;
        }

        @Override
        public TaskScheduleDetails build() {
            return new TaskScheduleDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
