/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FsxProtocol implements SdkPojo, Serializable, ToCopyableBuilder<FsxProtocol.Builder, FsxProtocol> {
    private static final SdkField<FsxProtocolNfs> NFS_FIELD = SdkField.<FsxProtocolNfs> builder(MarshallingType.SDK_POJO)
            .memberName("NFS").getter(getter(FsxProtocol::nfs)).setter(setter(Builder::nfs)).constructor(FsxProtocolNfs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFS").build()).build();

    private static final SdkField<FsxProtocolSmb> SMB_FIELD = SdkField.<FsxProtocolSmb> builder(MarshallingType.SDK_POJO)
            .memberName("SMB").getter(getter(FsxProtocol::smb)).setter(setter(Builder::smb)).constructor(FsxProtocolSmb::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NFS_FIELD, SMB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FsxProtocolNfs nfs;

    private final FsxProtocolSmb smb;

    private FsxProtocol(BuilderImpl builder) {
        this.nfs = builder.nfs;
        this.smb = builder.smb;
    }

    /**
     * <p>
     * Specifies the Network File System (NFS) protocol configuration that DataSync uses to access your FSx for OpenZFS
     * file system or FSx for ONTAP file system's storage virtual machine (SVM).
     * </p>
     * 
     * @return Specifies the Network File System (NFS) protocol configuration that DataSync uses to access your FSx for
     *         OpenZFS file system or FSx for ONTAP file system's storage virtual machine (SVM).
     */
    public final FsxProtocolNfs nfs() {
        return nfs;
    }

    /**
     * <p>
     * Specifies the Server Message Block (SMB) protocol configuration that DataSync uses to access your FSx for ONTAP
     * file system's SVM.
     * </p>
     * 
     * @return Specifies the Server Message Block (SMB) protocol configuration that DataSync uses to access your FSx for
     *         ONTAP file system's SVM.
     */
    public final FsxProtocolSmb smb() {
        return smb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nfs());
        hashCode = 31 * hashCode + Objects.hashCode(smb());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FsxProtocol)) {
            return false;
        }
        FsxProtocol other = (FsxProtocol) obj;
        return Objects.equals(nfs(), other.nfs()) && Objects.equals(smb(), other.smb());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FsxProtocol").add("NFS", nfs()).add("SMB", smb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NFS":
            return Optional.ofNullable(clazz.cast(nfs()));
        case "SMB":
            return Optional.ofNullable(clazz.cast(smb()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NFS", NFS_FIELD);
        map.put("SMB", SMB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FsxProtocol, T> g) {
        return obj -> g.apply((FsxProtocol) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FsxProtocol> {
        /**
         * <p>
         * Specifies the Network File System (NFS) protocol configuration that DataSync uses to access your FSx for
         * OpenZFS file system or FSx for ONTAP file system's storage virtual machine (SVM).
         * </p>
         * 
         * @param nfs
         *        Specifies the Network File System (NFS) protocol configuration that DataSync uses to access your FSx
         *        for OpenZFS file system or FSx for ONTAP file system's storage virtual machine (SVM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nfs(FsxProtocolNfs nfs);

        /**
         * <p>
         * Specifies the Network File System (NFS) protocol configuration that DataSync uses to access your FSx for
         * OpenZFS file system or FSx for ONTAP file system's storage virtual machine (SVM).
         * </p>
         * This is a convenience method that creates an instance of the {@link FsxProtocolNfs.Builder} avoiding the need
         * to create one manually via {@link FsxProtocolNfs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FsxProtocolNfs.Builder#build()} is called immediately and its
         * result is passed to {@link #nfs(FsxProtocolNfs)}.
         * 
         * @param nfs
         *        a consumer that will call methods on {@link FsxProtocolNfs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nfs(FsxProtocolNfs)
         */
        default Builder nfs(Consumer<FsxProtocolNfs.Builder> nfs) {
            return nfs(FsxProtocolNfs.builder().applyMutation(nfs).build());
        }

        /**
         * <p>
         * Specifies the Server Message Block (SMB) protocol configuration that DataSync uses to access your FSx for
         * ONTAP file system's SVM.
         * </p>
         * 
         * @param smb
         *        Specifies the Server Message Block (SMB) protocol configuration that DataSync uses to access your FSx
         *        for ONTAP file system's SVM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smb(FsxProtocolSmb smb);

        /**
         * <p>
         * Specifies the Server Message Block (SMB) protocol configuration that DataSync uses to access your FSx for
         * ONTAP file system's SVM.
         * </p>
         * This is a convenience method that creates an instance of the {@link FsxProtocolSmb.Builder} avoiding the need
         * to create one manually via {@link FsxProtocolSmb#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FsxProtocolSmb.Builder#build()} is called immediately and its
         * result is passed to {@link #smb(FsxProtocolSmb)}.
         * 
         * @param smb
         *        a consumer that will call methods on {@link FsxProtocolSmb.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smb(FsxProtocolSmb)
         */
        default Builder smb(Consumer<FsxProtocolSmb.Builder> smb) {
            return smb(FsxProtocolSmb.builder().applyMutation(smb).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FsxProtocolNfs nfs;

        private FsxProtocolSmb smb;

        private BuilderImpl() {
        }

        private BuilderImpl(FsxProtocol model) {
            nfs(model.nfs);
            smb(model.smb);
        }

        public final FsxProtocolNfs.Builder getNfs() {
            return nfs != null ? nfs.toBuilder() : null;
        }

        public final void setNfs(FsxProtocolNfs.BuilderImpl nfs) {
            this.nfs = nfs != null ? nfs.build() : null;
        }

        @Override
        public final Builder nfs(FsxProtocolNfs nfs) {
            this.nfs = nfs;
            return this;
        }

        public final FsxProtocolSmb.Builder getSmb() {
            return smb != null ? smb.toBuilder() : null;
        }

        public final void setSmb(FsxProtocolSmb.BuilderImpl smb) {
            this.smb = smb != null ? smb.build() : null;
        }

        @Override
        public final Builder smb(FsxProtocolSmb smb) {
            this.smb = smb;
            return this;
        }

        @Override
        public FsxProtocol build() {
            return new FsxProtocol(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
