/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration information for a customer-managed Secrets Manager secret where a storage location
 * authentication token or secret key is stored in plain text. This configuration includes the secret ARN, and the ARN
 * for an IAM role that provides access to the secret.
 * </p>
 * <note>
 * <p>
 * You can use either <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> to provide credentials for a
 * <code>CreateLocation</code> request. Do not provide both parameters for the same request.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomSecretConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomSecretConfig.Builder, CustomSecretConfig> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(CustomSecretConfig::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> SECRET_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretAccessRoleArn").getter(getter(CustomSecretConfig::secretAccessRoleArn))
            .setter(setter(Builder::secretAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretAccessRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD,
            SECRET_ACCESS_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String secretArn;

    private final String secretAccessRoleArn;

    private CustomSecretConfig(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.secretAccessRoleArn = builder.secretAccessRoleArn;
    }

    /**
     * <p>
     * Specifies the ARN for an Secrets Manager secret.
     * </p>
     * 
     * @return Specifies the ARN for an Secrets Manager secret.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * Specifies the ARN for the Identity and Access Management role that DataSync uses to access the secret specified
     * for <code>SecretArn</code>.
     * </p>
     * 
     * @return Specifies the ARN for the Identity and Access Management role that DataSync uses to access the secret
     *         specified for <code>SecretArn</code>.
     */
    public final String secretAccessRoleArn() {
        return secretAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretAccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomSecretConfig)) {
            return false;
        }
        CustomSecretConfig other = (CustomSecretConfig) obj;
        return Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(secretAccessRoleArn(), other.secretAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomSecretConfig").add("SecretArn", secretArn())
                .add("SecretAccessRoleArn", secretAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "SecretAccessRoleArn":
            return Optional.ofNullable(clazz.cast(secretAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("SecretAccessRoleArn", SECRET_ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomSecretConfig, T> g) {
        return obj -> g.apply((CustomSecretConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomSecretConfig> {
        /**
         * <p>
         * Specifies the ARN for an Secrets Manager secret.
         * </p>
         * 
         * @param secretArn
         *        Specifies the ARN for an Secrets Manager secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * Specifies the ARN for the Identity and Access Management role that DataSync uses to access the secret
         * specified for <code>SecretArn</code>.
         * </p>
         * 
         * @param secretAccessRoleArn
         *        Specifies the ARN for the Identity and Access Management role that DataSync uses to access the secret
         *        specified for <code>SecretArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretAccessRoleArn(String secretAccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String secretArn;

        private String secretAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomSecretConfig model) {
            secretArn(model.secretArn);
            secretAccessRoleArn(model.secretAccessRoleArn);
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSecretAccessRoleArn() {
            return secretAccessRoleArn;
        }

        public final void setSecretAccessRoleArn(String secretAccessRoleArn) {
            this.secretAccessRoleArn = secretAccessRoleArn;
        }

        @Override
        public final Builder secretAccessRoleArn(String secretAccessRoleArn) {
            this.secretAccessRoleArn = secretAccessRoleArn;
            return this;
        }

        @Override
        public CustomSecretConfig build() {
            return new CustomSecretConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
