/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.Ec2SecurityGroupArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocationFsxLustreResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeLocationFsxLustreResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(DescribeLocationFsxLustreResponse.getter(DescribeLocationFsxLustreResponse::locationArn)).setter(DescribeLocationFsxLustreResponse.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationUri").getter(DescribeLocationFsxLustreResponse.getter(DescribeLocationFsxLustreResponse::locationUri)).setter(DescribeLocationFsxLustreResponse.setter(Builder::locationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupArns").getter(DescribeLocationFsxLustreResponse.getter(DescribeLocationFsxLustreResponse::securityGroupArns)).setter(DescribeLocationFsxLustreResponse.setter(Builder::securityGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeLocationFsxLustreResponse.getter(DescribeLocationFsxLustreResponse::creationTime)).setter(DescribeLocationFsxLustreResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, LOCATION_URI_FIELD, SECURITY_GROUP_ARNS_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeLocationFsxLustreResponse.memberNameToFieldInitializer();
    private final String locationArn;
    private final String locationUri;
    private final List<String> securityGroupArns;
    private final Instant creationTime;

    private DescribeLocationFsxLustreResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.securityGroupArns = builder.securityGroupArns;
        this.creationTime = builder.creationTime;
    }

    public final String locationArn() {
        return this.locationArn;
    }

    public final String locationUri() {
        return this.locationUri;
    }

    public final boolean hasSecurityGroupArns() {
        return this.securityGroupArns != null && !(this.securityGroupArns instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupArns() {
        return this.securityGroupArns;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupArns() ? this.securityGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationFsxLustreResponse)) {
            return false;
        }
        DescribeLocationFsxLustreResponse other = (DescribeLocationFsxLustreResponse)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.locationUri(), other.locationUri()) && this.hasSecurityGroupArns() == other.hasSecurityGroupArns() && Objects.equals(this.securityGroupArns(), other.securityGroupArns()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLocationFsxLustreResponse").add("LocationArn", (Object)this.locationArn()).add("LocationUri", (Object)this.locationUri()).add("SecurityGroupArns", this.hasSecurityGroupArns() ? this.securityGroupArns() : null).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "LocationUri": {
                return Optional.ofNullable(clazz.cast(this.locationUri()));
            }
            case "SecurityGroupArns": {
                return Optional.ofNullable(clazz.cast(this.securityGroupArns()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("LocationUri", LOCATION_URI_FIELD);
        map.put("SecurityGroupArns", SECURITY_GROUP_ARNS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationFsxLustreResponse, T> g) {
        return obj -> g.apply((DescribeLocationFsxLustreResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String locationArn;
        private String locationUri;
        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationFsxLustreResponse model) {
            super(model);
            this.locationArn(model.locationArn);
            this.locationUri(model.locationUri);
            this.securityGroupArns(model.securityGroupArns);
            this.creationTime(model.creationTime);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getLocationUri() {
            return this.locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final Collection<String> getSecurityGroupArns() {
            if (this.securityGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupArns;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
        }

        @Override
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupArns(String ... securityGroupArns) {
            this.securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public DescribeLocationFsxLustreResponse build() {
            return new DescribeLocationFsxLustreResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocationFsxLustreResponse> {
        public Builder locationArn(String var1);

        public Builder locationUri(String var1);

        public Builder securityGroupArns(Collection<String> var1);

        public Builder securityGroupArns(String ... var1);

        public Builder creationTime(Instant var1);
    }
}

