/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.Capacity;
import software.amazon.awssdk.services.datasync.model.DiscoveryResourceType;
import software.amazon.awssdk.services.datasync.model.P95Metrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceMetrics> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(ResourceMetrics.getter(ResourceMetrics::timestamp)).setter(ResourceMetrics.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<P95Metrics> P95_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("P95Metrics").getter(ResourceMetrics.getter(ResourceMetrics::p95Metrics)).setter(ResourceMetrics.setter(Builder::p95Metrics)).constructor(P95Metrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("P95Metrics").build()}).build();
    private static final SdkField<Capacity> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Capacity").getter(ResourceMetrics.getter(ResourceMetrics::capacity)).setter(ResourceMetrics.setter(Builder::capacity)).constructor(Capacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ResourceMetrics.getter(ResourceMetrics::resourceId)).setter(ResourceMetrics.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceMetrics.getter(ResourceMetrics::resourceTypeAsString)).setter(ResourceMetrics.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, P95_METRICS_FIELD, CAPACITY_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final P95Metrics p95Metrics;
    private final Capacity capacity;
    private final String resourceId;
    private final String resourceType;

    private ResourceMetrics(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.p95Metrics = builder.p95Metrics;
        this.capacity = builder.capacity;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final P95Metrics p95Metrics() {
        return this.p95Metrics;
    }

    public final Capacity capacity() {
        return this.capacity;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final DiscoveryResourceType resourceType() {
        return DiscoveryResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.p95Metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceMetrics)) {
            return false;
        }
        ResourceMetrics other = (ResourceMetrics)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.p95Metrics(), other.p95Metrics()) && Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceMetrics").add("Timestamp", (Object)this.timestamp()).add("P95Metrics", (Object)this.p95Metrics()).add("Capacity", (Object)this.capacity()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "P95Metrics": {
                return Optional.ofNullable(clazz.cast(this.p95Metrics()));
            }
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("P95Metrics", P95_METRICS_FIELD);
        map.put("Capacity", CAPACITY_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceMetrics, T> g) {
        return obj -> g.apply((ResourceMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private P95Metrics p95Metrics;
        private Capacity capacity;
        private String resourceId;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceMetrics model) {
            this.timestamp(model.timestamp);
            this.p95Metrics(model.p95Metrics);
            this.capacity(model.capacity);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final P95Metrics.Builder getP95Metrics() {
            return this.p95Metrics != null ? this.p95Metrics.toBuilder() : null;
        }

        public final void setP95Metrics(P95Metrics.BuilderImpl p95Metrics) {
            this.p95Metrics = p95Metrics != null ? p95Metrics.build() : null;
        }

        @Override
        public final Builder p95Metrics(P95Metrics p95Metrics) {
            this.p95Metrics = p95Metrics;
            return this;
        }

        public final Capacity.Builder getCapacity() {
            return this.capacity != null ? this.capacity.toBuilder() : null;
        }

        public final void setCapacity(Capacity.BuilderImpl capacity) {
            this.capacity = capacity != null ? capacity.build() : null;
        }

        @Override
        public final Builder capacity(Capacity capacity) {
            this.capacity = capacity;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(DiscoveryResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public ResourceMetrics build() {
            return new ResourceMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceMetrics> {
        public Builder timestamp(Instant var1);

        public Builder p95Metrics(P95Metrics var1);

        default public Builder p95Metrics(Consumer<P95Metrics.Builder> p95Metrics) {
            return this.p95Metrics((P95Metrics)((P95Metrics.Builder)P95Metrics.builder().applyMutation(p95Metrics)).build());
        }

        public Builder capacity(Capacity var1);

        default public Builder capacity(Consumer<Capacity.Builder> capacity) {
            return this.capacity((Capacity)((Capacity.Builder)Capacity.builder().applyMutation(capacity)).build());
        }

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(DiscoveryResourceType var1);
    }
}

