/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.Credentials;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.DiscoveryAgentArnListCopier;
import software.amazon.awssdk.services.datasync.model.DiscoveryServerConfiguration;
import software.amazon.awssdk.services.datasync.model.DiscoverySystemType;
import software.amazon.awssdk.services.datasync.model.InputTagListCopier;
import software.amazon.awssdk.services.datasync.model.TagListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddStorageSystemRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, AddStorageSystemRequest> {
    private static final SdkField<DiscoveryServerConfiguration> SERVER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerConfiguration").getter(AddStorageSystemRequest.getter(AddStorageSystemRequest::serverConfiguration)).setter(AddStorageSystemRequest.setter(Builder::serverConfiguration)).constructor(DiscoveryServerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerConfiguration").build()}).build();
    private static final SdkField<String> SYSTEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SystemType").getter(AddStorageSystemRequest.getter(AddStorageSystemRequest::systemTypeAsString)).setter(AddStorageSystemRequest.setter(Builder::systemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemType").build()}).build();
    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentArns").getter(AddStorageSystemRequest.getter(AddStorageSystemRequest::agentArns)).setter(AddStorageSystemRequest.setter(Builder::agentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLogGroupArn").getter(AddStorageSystemRequest.getter(AddStorageSystemRequest::cloudWatchLogGroupArn)).setter(AddStorageSystemRequest.setter(Builder::cloudWatchLogGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build()}).build();
    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(AddStorageSystemRequest.getter(AddStorageSystemRequest::tags)).setter(AddStorageSystemRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AddStorageSystemRequest.getter(AddStorageSystemRequest::name)).setter(AddStorageSystemRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(AddStorageSystemRequest.getter(AddStorageSystemRequest::clientToken)).setter(AddStorageSystemRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(AddStorageSystemRequest.getter(AddStorageSystemRequest::credentials)).setter(AddStorageSystemRequest.setter(Builder::credentials)).constructor(Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_CONFIGURATION_FIELD, SYSTEM_TYPE_FIELD, AGENT_ARNS_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, TAGS_FIELD, NAME_FIELD, CLIENT_TOKEN_FIELD, CREDENTIALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddStorageSystemRequest.memberNameToFieldInitializer();
    private final DiscoveryServerConfiguration serverConfiguration;
    private final String systemType;
    private final List<String> agentArns;
    private final String cloudWatchLogGroupArn;
    private final List<TagListEntry> tags;
    private final String name;
    private final String clientToken;
    private final Credentials credentials;

    private AddStorageSystemRequest(BuilderImpl builder) {
        super(builder);
        this.serverConfiguration = builder.serverConfiguration;
        this.systemType = builder.systemType;
        this.agentArns = builder.agentArns;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.tags = builder.tags;
        this.name = builder.name;
        this.clientToken = builder.clientToken;
        this.credentials = builder.credentials;
    }

    public final DiscoveryServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public final DiscoverySystemType systemType() {
        return DiscoverySystemType.fromValue(this.systemType);
    }

    public final String systemTypeAsString() {
        return this.systemType;
    }

    public final boolean hasAgentArns() {
        return this.agentArns != null && !(this.agentArns instanceof SdkAutoConstructList);
    }

    public final List<String> agentArns() {
        return this.agentArns;
    }

    public final String cloudWatchLogGroupArn() {
        return this.cloudWatchLogGroupArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<TagListEntry> tags() {
        return this.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Credentials credentials() {
        return this.credentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentArns() ? this.agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddStorageSystemRequest)) {
            return false;
        }
        AddStorageSystemRequest other = (AddStorageSystemRequest)((Object)obj);
        return Objects.equals(this.serverConfiguration(), other.serverConfiguration()) && Objects.equals(this.systemTypeAsString(), other.systemTypeAsString()) && this.hasAgentArns() == other.hasAgentArns() && Objects.equals(this.agentArns(), other.agentArns()) && Objects.equals(this.cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.credentials(), other.credentials());
    }

    public final String toString() {
        return ToString.builder((String)"AddStorageSystemRequest").add("ServerConfiguration", (Object)this.serverConfiguration()).add("SystemType", (Object)this.systemTypeAsString()).add("AgentArns", this.hasAgentArns() ? this.agentArns() : null).add("CloudWatchLogGroupArn", (Object)this.cloudWatchLogGroupArn()).add("Tags", this.hasTags() ? this.tags() : null).add("Name", (Object)this.name()).add("ClientToken", (Object)this.clientToken()).add("Credentials", (Object)this.credentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverConfiguration()));
            }
            case "SystemType": {
                return Optional.ofNullable(clazz.cast(this.systemTypeAsString()));
            }
            case "AgentArns": {
                return Optional.ofNullable(clazz.cast(this.agentArns()));
            }
            case "CloudWatchLogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServerConfiguration", SERVER_CONFIGURATION_FIELD);
        map.put("SystemType", SYSTEM_TYPE_FIELD);
        map.put("AgentArns", AGENT_ARNS_FIELD);
        map.put("CloudWatchLogGroupArn", CLOUD_WATCH_LOG_GROUP_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Credentials", CREDENTIALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddStorageSystemRequest, T> g) {
        return obj -> g.apply((AddStorageSystemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private DiscoveryServerConfiguration serverConfiguration;
        private String systemType;
        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();
        private String cloudWatchLogGroupArn;
        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String clientToken;
        private Credentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(AddStorageSystemRequest model) {
            super(model);
            this.serverConfiguration(model.serverConfiguration);
            this.systemType(model.systemType);
            this.agentArns(model.agentArns);
            this.cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            this.tags(model.tags);
            this.name(model.name);
            this.clientToken(model.clientToken);
            this.credentials(model.credentials);
        }

        public final DiscoveryServerConfiguration.Builder getServerConfiguration() {
            return this.serverConfiguration != null ? this.serverConfiguration.toBuilder() : null;
        }

        public final void setServerConfiguration(DiscoveryServerConfiguration.BuilderImpl serverConfiguration) {
            this.serverConfiguration = serverConfiguration != null ? serverConfiguration.build() : null;
        }

        @Override
        public final Builder serverConfiguration(DiscoveryServerConfiguration serverConfiguration) {
            this.serverConfiguration = serverConfiguration;
            return this;
        }

        public final String getSystemType() {
            return this.systemType;
        }

        public final void setSystemType(String systemType) {
            this.systemType = systemType;
        }

        @Override
        public final Builder systemType(String systemType) {
            this.systemType = systemType;
            return this;
        }

        @Override
        public final Builder systemType(DiscoverySystemType systemType) {
            this.systemType(systemType == null ? null : systemType.toString());
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (this.agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = DiscoveryAgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = DiscoveryAgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String ... agentArns) {
            this.agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final String getCloudWatchLogGroupArn() {
            return this.cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagListEntry)((TagListEntry.Builder)TagListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddStorageSystemRequest build() {
            return new AddStorageSystemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddStorageSystemRequest> {
        public Builder serverConfiguration(DiscoveryServerConfiguration var1);

        default public Builder serverConfiguration(Consumer<DiscoveryServerConfiguration.Builder> serverConfiguration) {
            return this.serverConfiguration((DiscoveryServerConfiguration)((DiscoveryServerConfiguration.Builder)DiscoveryServerConfiguration.builder().applyMutation(serverConfiguration)).build());
        }

        public Builder systemType(String var1);

        public Builder systemType(DiscoverySystemType var1);

        public Builder agentArns(Collection<String> var1);

        public Builder agentArns(String ... var1);

        public Builder cloudWatchLogGroupArn(String var1);

        public Builder tags(Collection<TagListEntry> var1);

        public Builder tags(TagListEntry ... var1);

        public Builder tags(Consumer<TagListEntry.Builder> ... var1);

        public Builder name(String var1);

        public Builder clientToken(String var1);

        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().applyMutation(credentials)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

