/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.Options;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTaskExecutionRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, UpdateTaskExecutionRequest> {
    private static final SdkField<String> TASK_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskExecutionArn").getter(UpdateTaskExecutionRequest.getter(UpdateTaskExecutionRequest::taskExecutionArn)).setter(UpdateTaskExecutionRequest.setter(Builder::taskExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutionArn").build()}).build();
    private static final SdkField<Options> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(UpdateTaskExecutionRequest.getter(UpdateTaskExecutionRequest::options)).setter(UpdateTaskExecutionRequest.setter(Builder::options)).constructor(Options::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_EXECUTION_ARN_FIELD, OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTaskExecutionRequest.memberNameToFieldInitializer();
    private final String taskExecutionArn;
    private final Options options;

    private UpdateTaskExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.taskExecutionArn = builder.taskExecutionArn;
        this.options = builder.options;
    }

    public final String taskExecutionArn() {
        return this.taskExecutionArn;
    }

    public final Options options() {
        return this.options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTaskExecutionRequest)) {
            return false;
        }
        UpdateTaskExecutionRequest other = (UpdateTaskExecutionRequest)((Object)obj);
        return Objects.equals(this.taskExecutionArn(), other.taskExecutionArn()) && Objects.equals(this.options(), other.options());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTaskExecutionRequest").add("TaskExecutionArn", (Object)this.taskExecutionArn()).add("Options", (Object)this.options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.taskExecutionArn()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TaskExecutionArn", TASK_EXECUTION_ARN_FIELD);
        map.put("Options", OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTaskExecutionRequest, T> g) {
        return obj -> g.apply((UpdateTaskExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String taskExecutionArn;
        private Options options;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTaskExecutionRequest model) {
            super(model);
            this.taskExecutionArn(model.taskExecutionArn);
            this.options(model.options);
        }

        public final String getTaskExecutionArn() {
            return this.taskExecutionArn;
        }

        public final void setTaskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
        }

        @Override
        public final Builder taskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
            return this;
        }

        public final Options.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTaskExecutionRequest build() {
            return new UpdateTaskExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTaskExecutionRequest> {
        public Builder taskExecutionArn(String var1);

        public Builder options(Options var1);

        default public Builder options(Consumer<Options.Builder> options) {
            return this.options((Options)((Options.Builder)Options.builder().applyMutation(options)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

