/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.TaskExecutionStatus;
import software.amazon.awssdk.services.datasync.model.TaskMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskExecutionListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskExecutionListEntry> {
    private static final SdkField<String> TASK_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskExecutionArn").getter(TaskExecutionListEntry.getter(TaskExecutionListEntry::taskExecutionArn)).setter(TaskExecutionListEntry.setter(Builder::taskExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutionArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TaskExecutionListEntry.getter(TaskExecutionListEntry::statusAsString)).setter(TaskExecutionListEntry.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TASK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskMode").getter(TaskExecutionListEntry.getter(TaskExecutionListEntry::taskModeAsString)).setter(TaskExecutionListEntry.setter(Builder::taskMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_EXECUTION_ARN_FIELD, STATUS_FIELD, TASK_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String taskExecutionArn;
    private final String status;
    private final String taskMode;

    private TaskExecutionListEntry(BuilderImpl builder) {
        this.taskExecutionArn = builder.taskExecutionArn;
        this.status = builder.status;
        this.taskMode = builder.taskMode;
    }

    public final String taskExecutionArn() {
        return this.taskExecutionArn;
    }

    public final TaskExecutionStatus status() {
        return TaskExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final TaskMode taskMode() {
        return TaskMode.fromValue(this.taskMode);
    }

    public final String taskModeAsString() {
        return this.taskMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskExecutionListEntry)) {
            return false;
        }
        TaskExecutionListEntry other = (TaskExecutionListEntry)obj;
        return Objects.equals(this.taskExecutionArn(), other.taskExecutionArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.taskModeAsString(), other.taskModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TaskExecutionListEntry").add("TaskExecutionArn", (Object)this.taskExecutionArn()).add("Status", (Object)this.statusAsString()).add("TaskMode", (Object)this.taskModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.taskExecutionArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TaskMode": {
                return Optional.ofNullable(clazz.cast(this.taskModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskExecutionListEntry, T> g) {
        return obj -> g.apply((TaskExecutionListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskExecutionArn;
        private String status;
        private String taskMode;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskExecutionListEntry model) {
            this.taskExecutionArn(model.taskExecutionArn);
            this.status(model.status);
            this.taskMode(model.taskMode);
        }

        public final String getTaskExecutionArn() {
            return this.taskExecutionArn;
        }

        public final void setTaskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
        }

        @Override
        public final Builder taskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTaskMode() {
            return this.taskMode;
        }

        public final void setTaskMode(String taskMode) {
            this.taskMode = taskMode;
        }

        @Override
        public final Builder taskMode(String taskMode) {
            this.taskMode = taskMode;
            return this;
        }

        @Override
        public final Builder taskMode(TaskMode taskMode) {
            this.taskMode(taskMode == null ? null : taskMode.toString());
            return this;
        }

        public TaskExecutionListEntry build() {
            return new TaskExecutionListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskExecutionListEntry> {
        public Builder taskExecutionArn(String var1);

        public Builder status(String var1);

        public Builder status(TaskExecutionStatus var1);

        public Builder taskMode(String var1);

        public Builder taskMode(TaskMode var1);
    }
}

