/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.FilterListCopier;
import software.amazon.awssdk.services.datasync.model.FilterRule;
import software.amazon.awssdk.services.datasync.model.ManifestConfig;
import software.amazon.awssdk.services.datasync.model.Options;
import software.amazon.awssdk.services.datasync.model.ReportResult;
import software.amazon.awssdk.services.datasync.model.TaskExecutionFilesFailedDetail;
import software.amazon.awssdk.services.datasync.model.TaskExecutionFilesListedDetail;
import software.amazon.awssdk.services.datasync.model.TaskExecutionResultDetail;
import software.amazon.awssdk.services.datasync.model.TaskExecutionStatus;
import software.amazon.awssdk.services.datasync.model.TaskMode;
import software.amazon.awssdk.services.datasync.model.TaskReportConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTaskExecutionResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeTaskExecutionResponse> {
    private static final SdkField<String> TASK_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskExecutionArn").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::taskExecutionArn)).setter(DescribeTaskExecutionResponse.setter(Builder::taskExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutionArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::statusAsString)).setter(DescribeTaskExecutionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Options> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::options)).setter(DescribeTaskExecutionResponse.setter(Builder::options)).constructor(Options::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<List<FilterRule>> EXCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Excludes").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::excludes)).setter(DescribeTaskExecutionResponse.setter(Builder::excludes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excludes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FilterRule>> INCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Includes").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::includes)).setter(DescribeTaskExecutionResponse.setter(Builder::includes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Includes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ManifestConfig> MANIFEST_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestConfig").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::manifestConfig)).setter(DescribeTaskExecutionResponse.setter(Builder::manifestConfig)).constructor(ManifestConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestConfig").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::startTime)).setter(DescribeTaskExecutionResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Long> ESTIMATED_FILES_TO_TRANSFER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedFilesToTransfer").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::estimatedFilesToTransfer)).setter(DescribeTaskExecutionResponse.setter(Builder::estimatedFilesToTransfer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedFilesToTransfer").build()}).build();
    private static final SdkField<Long> ESTIMATED_BYTES_TO_TRANSFER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedBytesToTransfer").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::estimatedBytesToTransfer)).setter(DescribeTaskExecutionResponse.setter(Builder::estimatedBytesToTransfer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedBytesToTransfer").build()}).build();
    private static final SdkField<Long> FILES_TRANSFERRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FilesTransferred").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::filesTransferred)).setter(DescribeTaskExecutionResponse.setter(Builder::filesTransferred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesTransferred").build()}).build();
    private static final SdkField<Long> BYTES_WRITTEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesWritten").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::bytesWritten)).setter(DescribeTaskExecutionResponse.setter(Builder::bytesWritten)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesWritten").build()}).build();
    private static final SdkField<Long> BYTES_TRANSFERRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesTransferred").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::bytesTransferred)).setter(DescribeTaskExecutionResponse.setter(Builder::bytesTransferred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesTransferred").build()}).build();
    private static final SdkField<Long> BYTES_COMPRESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesCompressed").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::bytesCompressed)).setter(DescribeTaskExecutionResponse.setter(Builder::bytesCompressed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesCompressed").build()}).build();
    private static final SdkField<TaskExecutionResultDetail> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Result").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::result)).setter(DescribeTaskExecutionResponse.setter(Builder::result)).constructor(TaskExecutionResultDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()}).build();
    private static final SdkField<TaskReportConfig> TASK_REPORT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaskReportConfig").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::taskReportConfig)).setter(DescribeTaskExecutionResponse.setter(Builder::taskReportConfig)).constructor(TaskReportConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskReportConfig").build()}).build();
    private static final SdkField<Long> FILES_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FilesDeleted").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::filesDeleted)).setter(DescribeTaskExecutionResponse.setter(Builder::filesDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesDeleted").build()}).build();
    private static final SdkField<Long> FILES_SKIPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FilesSkipped").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::filesSkipped)).setter(DescribeTaskExecutionResponse.setter(Builder::filesSkipped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesSkipped").build()}).build();
    private static final SdkField<Long> FILES_VERIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FilesVerified").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::filesVerified)).setter(DescribeTaskExecutionResponse.setter(Builder::filesVerified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesVerified").build()}).build();
    private static final SdkField<ReportResult> REPORT_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportResult").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::reportResult)).setter(DescribeTaskExecutionResponse.setter(Builder::reportResult)).constructor(ReportResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportResult").build()}).build();
    private static final SdkField<Long> ESTIMATED_FILES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedFilesToDelete").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::estimatedFilesToDelete)).setter(DescribeTaskExecutionResponse.setter(Builder::estimatedFilesToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedFilesToDelete").build()}).build();
    private static final SdkField<String> TASK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskMode").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::taskModeAsString)).setter(DescribeTaskExecutionResponse.setter(Builder::taskMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskMode").build()}).build();
    private static final SdkField<Long> FILES_PREPARED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FilesPrepared").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::filesPrepared)).setter(DescribeTaskExecutionResponse.setter(Builder::filesPrepared)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesPrepared").build()}).build();
    private static final SdkField<TaskExecutionFilesListedDetail> FILES_LISTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilesListed").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::filesListed)).setter(DescribeTaskExecutionResponse.setter(Builder::filesListed)).constructor(TaskExecutionFilesListedDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesListed").build()}).build();
    private static final SdkField<TaskExecutionFilesFailedDetail> FILES_FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilesFailed").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::filesFailed)).setter(DescribeTaskExecutionResponse.setter(Builder::filesFailed)).constructor(TaskExecutionFilesFailedDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesFailed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_EXECUTION_ARN_FIELD, STATUS_FIELD, OPTIONS_FIELD, EXCLUDES_FIELD, INCLUDES_FIELD, MANIFEST_CONFIG_FIELD, START_TIME_FIELD, ESTIMATED_FILES_TO_TRANSFER_FIELD, ESTIMATED_BYTES_TO_TRANSFER_FIELD, FILES_TRANSFERRED_FIELD, BYTES_WRITTEN_FIELD, BYTES_TRANSFERRED_FIELD, BYTES_COMPRESSED_FIELD, RESULT_FIELD, TASK_REPORT_CONFIG_FIELD, FILES_DELETED_FIELD, FILES_SKIPPED_FIELD, FILES_VERIFIED_FIELD, REPORT_RESULT_FIELD, ESTIMATED_FILES_TO_DELETE_FIELD, TASK_MODE_FIELD, FILES_PREPARED_FIELD, FILES_LISTED_FIELD, FILES_FAILED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TaskExecutionArn", TASK_EXECUTION_ARN_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Options", OPTIONS_FIELD);
            this.put("Excludes", EXCLUDES_FIELD);
            this.put("Includes", INCLUDES_FIELD);
            this.put("ManifestConfig", MANIFEST_CONFIG_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EstimatedFilesToTransfer", ESTIMATED_FILES_TO_TRANSFER_FIELD);
            this.put("EstimatedBytesToTransfer", ESTIMATED_BYTES_TO_TRANSFER_FIELD);
            this.put("FilesTransferred", FILES_TRANSFERRED_FIELD);
            this.put("BytesWritten", BYTES_WRITTEN_FIELD);
            this.put("BytesTransferred", BYTES_TRANSFERRED_FIELD);
            this.put("BytesCompressed", BYTES_COMPRESSED_FIELD);
            this.put("Result", RESULT_FIELD);
            this.put("TaskReportConfig", TASK_REPORT_CONFIG_FIELD);
            this.put("FilesDeleted", FILES_DELETED_FIELD);
            this.put("FilesSkipped", FILES_SKIPPED_FIELD);
            this.put("FilesVerified", FILES_VERIFIED_FIELD);
            this.put("ReportResult", REPORT_RESULT_FIELD);
            this.put("EstimatedFilesToDelete", ESTIMATED_FILES_TO_DELETE_FIELD);
            this.put("TaskMode", TASK_MODE_FIELD);
            this.put("FilesPrepared", FILES_PREPARED_FIELD);
            this.put("FilesListed", FILES_LISTED_FIELD);
            this.put("FilesFailed", FILES_FAILED_FIELD);
        }
    });
    private final String taskExecutionArn;
    private final String status;
    private final Options options;
    private final List<FilterRule> excludes;
    private final List<FilterRule> includes;
    private final ManifestConfig manifestConfig;
    private final Instant startTime;
    private final Long estimatedFilesToTransfer;
    private final Long estimatedBytesToTransfer;
    private final Long filesTransferred;
    private final Long bytesWritten;
    private final Long bytesTransferred;
    private final Long bytesCompressed;
    private final TaskExecutionResultDetail result;
    private final TaskReportConfig taskReportConfig;
    private final Long filesDeleted;
    private final Long filesSkipped;
    private final Long filesVerified;
    private final ReportResult reportResult;
    private final Long estimatedFilesToDelete;
    private final String taskMode;
    private final Long filesPrepared;
    private final TaskExecutionFilesListedDetail filesListed;
    private final TaskExecutionFilesFailedDetail filesFailed;

    private DescribeTaskExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.taskExecutionArn = builder.taskExecutionArn;
        this.status = builder.status;
        this.options = builder.options;
        this.excludes = builder.excludes;
        this.includes = builder.includes;
        this.manifestConfig = builder.manifestConfig;
        this.startTime = builder.startTime;
        this.estimatedFilesToTransfer = builder.estimatedFilesToTransfer;
        this.estimatedBytesToTransfer = builder.estimatedBytesToTransfer;
        this.filesTransferred = builder.filesTransferred;
        this.bytesWritten = builder.bytesWritten;
        this.bytesTransferred = builder.bytesTransferred;
        this.bytesCompressed = builder.bytesCompressed;
        this.result = builder.result;
        this.taskReportConfig = builder.taskReportConfig;
        this.filesDeleted = builder.filesDeleted;
        this.filesSkipped = builder.filesSkipped;
        this.filesVerified = builder.filesVerified;
        this.reportResult = builder.reportResult;
        this.estimatedFilesToDelete = builder.estimatedFilesToDelete;
        this.taskMode = builder.taskMode;
        this.filesPrepared = builder.filesPrepared;
        this.filesListed = builder.filesListed;
        this.filesFailed = builder.filesFailed;
    }

    public final String taskExecutionArn() {
        return this.taskExecutionArn;
    }

    public final TaskExecutionStatus status() {
        return TaskExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Options options() {
        return this.options;
    }

    public final boolean hasExcludes() {
        return this.excludes != null && !(this.excludes instanceof SdkAutoConstructList);
    }

    public final List<FilterRule> excludes() {
        return this.excludes;
    }

    public final boolean hasIncludes() {
        return this.includes != null && !(this.includes instanceof SdkAutoConstructList);
    }

    public final List<FilterRule> includes() {
        return this.includes;
    }

    public final ManifestConfig manifestConfig() {
        return this.manifestConfig;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Long estimatedFilesToTransfer() {
        return this.estimatedFilesToTransfer;
    }

    public final Long estimatedBytesToTransfer() {
        return this.estimatedBytesToTransfer;
    }

    public final Long filesTransferred() {
        return this.filesTransferred;
    }

    public final Long bytesWritten() {
        return this.bytesWritten;
    }

    public final Long bytesTransferred() {
        return this.bytesTransferred;
    }

    public final Long bytesCompressed() {
        return this.bytesCompressed;
    }

    public final TaskExecutionResultDetail result() {
        return this.result;
    }

    public final TaskReportConfig taskReportConfig() {
        return this.taskReportConfig;
    }

    public final Long filesDeleted() {
        return this.filesDeleted;
    }

    public final Long filesSkipped() {
        return this.filesSkipped;
    }

    public final Long filesVerified() {
        return this.filesVerified;
    }

    public final ReportResult reportResult() {
        return this.reportResult;
    }

    public final Long estimatedFilesToDelete() {
        return this.estimatedFilesToDelete;
    }

    public final TaskMode taskMode() {
        return TaskMode.fromValue(this.taskMode);
    }

    public final String taskModeAsString() {
        return this.taskMode;
    }

    public final Long filesPrepared() {
        return this.filesPrepared;
    }

    public final TaskExecutionFilesListedDetail filesListed() {
        return this.filesListed;
    }

    public final TaskExecutionFilesFailedDetail filesFailed() {
        return this.filesFailed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludes() ? this.excludes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludes() ? this.includes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedFilesToTransfer());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedBytesToTransfer());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesTransferred());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesWritten());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesTransferred());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesCompressed());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskReportConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesSkipped());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesVerified());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedFilesToDelete());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesPrepared());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesListed());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesFailed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskExecutionResponse)) {
            return false;
        }
        DescribeTaskExecutionResponse other = (DescribeTaskExecutionResponse)((Object)obj);
        return Objects.equals(this.taskExecutionArn(), other.taskExecutionArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.options(), other.options()) && this.hasExcludes() == other.hasExcludes() && Objects.equals(this.excludes(), other.excludes()) && this.hasIncludes() == other.hasIncludes() && Objects.equals(this.includes(), other.includes()) && Objects.equals(this.manifestConfig(), other.manifestConfig()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.estimatedFilesToTransfer(), other.estimatedFilesToTransfer()) && Objects.equals(this.estimatedBytesToTransfer(), other.estimatedBytesToTransfer()) && Objects.equals(this.filesTransferred(), other.filesTransferred()) && Objects.equals(this.bytesWritten(), other.bytesWritten()) && Objects.equals(this.bytesTransferred(), other.bytesTransferred()) && Objects.equals(this.bytesCompressed(), other.bytesCompressed()) && Objects.equals(this.result(), other.result()) && Objects.equals(this.taskReportConfig(), other.taskReportConfig()) && Objects.equals(this.filesDeleted(), other.filesDeleted()) && Objects.equals(this.filesSkipped(), other.filesSkipped()) && Objects.equals(this.filesVerified(), other.filesVerified()) && Objects.equals(this.reportResult(), other.reportResult()) && Objects.equals(this.estimatedFilesToDelete(), other.estimatedFilesToDelete()) && Objects.equals(this.taskModeAsString(), other.taskModeAsString()) && Objects.equals(this.filesPrepared(), other.filesPrepared()) && Objects.equals(this.filesListed(), other.filesListed()) && Objects.equals(this.filesFailed(), other.filesFailed());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTaskExecutionResponse").add("TaskExecutionArn", (Object)this.taskExecutionArn()).add("Status", (Object)this.statusAsString()).add("Options", (Object)this.options()).add("Excludes", this.hasExcludes() ? this.excludes() : null).add("Includes", this.hasIncludes() ? this.includes() : null).add("ManifestConfig", (Object)this.manifestConfig()).add("StartTime", (Object)this.startTime()).add("EstimatedFilesToTransfer", (Object)this.estimatedFilesToTransfer()).add("EstimatedBytesToTransfer", (Object)this.estimatedBytesToTransfer()).add("FilesTransferred", (Object)this.filesTransferred()).add("BytesWritten", (Object)this.bytesWritten()).add("BytesTransferred", (Object)this.bytesTransferred()).add("BytesCompressed", (Object)this.bytesCompressed()).add("Result", (Object)this.result()).add("TaskReportConfig", (Object)this.taskReportConfig()).add("FilesDeleted", (Object)this.filesDeleted()).add("FilesSkipped", (Object)this.filesSkipped()).add("FilesVerified", (Object)this.filesVerified()).add("ReportResult", (Object)this.reportResult()).add("EstimatedFilesToDelete", (Object)this.estimatedFilesToDelete()).add("TaskMode", (Object)this.taskModeAsString()).add("FilesPrepared", (Object)this.filesPrepared()).add("FilesListed", (Object)this.filesListed()).add("FilesFailed", (Object)this.filesFailed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.taskExecutionArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Excludes": {
                return Optional.ofNullable(clazz.cast(this.excludes()));
            }
            case "Includes": {
                return Optional.ofNullable(clazz.cast(this.includes()));
            }
            case "ManifestConfig": {
                return Optional.ofNullable(clazz.cast(this.manifestConfig()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EstimatedFilesToTransfer": {
                return Optional.ofNullable(clazz.cast(this.estimatedFilesToTransfer()));
            }
            case "EstimatedBytesToTransfer": {
                return Optional.ofNullable(clazz.cast(this.estimatedBytesToTransfer()));
            }
            case "FilesTransferred": {
                return Optional.ofNullable(clazz.cast(this.filesTransferred()));
            }
            case "BytesWritten": {
                return Optional.ofNullable(clazz.cast(this.bytesWritten()));
            }
            case "BytesTransferred": {
                return Optional.ofNullable(clazz.cast(this.bytesTransferred()));
            }
            case "BytesCompressed": {
                return Optional.ofNullable(clazz.cast(this.bytesCompressed()));
            }
            case "Result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
            case "TaskReportConfig": {
                return Optional.ofNullable(clazz.cast(this.taskReportConfig()));
            }
            case "FilesDeleted": {
                return Optional.ofNullable(clazz.cast(this.filesDeleted()));
            }
            case "FilesSkipped": {
                return Optional.ofNullable(clazz.cast(this.filesSkipped()));
            }
            case "FilesVerified": {
                return Optional.ofNullable(clazz.cast(this.filesVerified()));
            }
            case "ReportResult": {
                return Optional.ofNullable(clazz.cast(this.reportResult()));
            }
            case "EstimatedFilesToDelete": {
                return Optional.ofNullable(clazz.cast(this.estimatedFilesToDelete()));
            }
            case "TaskMode": {
                return Optional.ofNullable(clazz.cast(this.taskModeAsString()));
            }
            case "FilesPrepared": {
                return Optional.ofNullable(clazz.cast(this.filesPrepared()));
            }
            case "FilesListed": {
                return Optional.ofNullable(clazz.cast(this.filesListed()));
            }
            case "FilesFailed": {
                return Optional.ofNullable(clazz.cast(this.filesFailed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTaskExecutionResponse, T> g) {
        return obj -> g.apply((DescribeTaskExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String taskExecutionArn;
        private String status;
        private Options options;
        private List<FilterRule> excludes = DefaultSdkAutoConstructList.getInstance();
        private List<FilterRule> includes = DefaultSdkAutoConstructList.getInstance();
        private ManifestConfig manifestConfig;
        private Instant startTime;
        private Long estimatedFilesToTransfer;
        private Long estimatedBytesToTransfer;
        private Long filesTransferred;
        private Long bytesWritten;
        private Long bytesTransferred;
        private Long bytesCompressed;
        private TaskExecutionResultDetail result;
        private TaskReportConfig taskReportConfig;
        private Long filesDeleted;
        private Long filesSkipped;
        private Long filesVerified;
        private ReportResult reportResult;
        private Long estimatedFilesToDelete;
        private String taskMode;
        private Long filesPrepared;
        private TaskExecutionFilesListedDetail filesListed;
        private TaskExecutionFilesFailedDetail filesFailed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTaskExecutionResponse model) {
            super(model);
            this.taskExecutionArn(model.taskExecutionArn);
            this.status(model.status);
            this.options(model.options);
            this.excludes(model.excludes);
            this.includes(model.includes);
            this.manifestConfig(model.manifestConfig);
            this.startTime(model.startTime);
            this.estimatedFilesToTransfer(model.estimatedFilesToTransfer);
            this.estimatedBytesToTransfer(model.estimatedBytesToTransfer);
            this.filesTransferred(model.filesTransferred);
            this.bytesWritten(model.bytesWritten);
            this.bytesTransferred(model.bytesTransferred);
            this.bytesCompressed(model.bytesCompressed);
            this.result(model.result);
            this.taskReportConfig(model.taskReportConfig);
            this.filesDeleted(model.filesDeleted);
            this.filesSkipped(model.filesSkipped);
            this.filesVerified(model.filesVerified);
            this.reportResult(model.reportResult);
            this.estimatedFilesToDelete(model.estimatedFilesToDelete);
            this.taskMode(model.taskMode);
            this.filesPrepared(model.filesPrepared);
            this.filesListed(model.filesListed);
            this.filesFailed(model.filesFailed);
        }

        public final String getTaskExecutionArn() {
            return this.taskExecutionArn;
        }

        public final void setTaskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
        }

        @Override
        public final Builder taskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Options.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        public final List<FilterRule.Builder> getExcludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.excludes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludes(Collection<FilterRule.BuilderImpl> excludes) {
            this.excludes = FilterListCopier.copyFromBuilder(excludes);
        }

        @Override
        public final Builder excludes(Collection<FilterRule> excludes) {
            this.excludes = FilterListCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(FilterRule ... excludes) {
            this.excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(Consumer<FilterRule.Builder> ... excludes) {
            this.excludes(Stream.of(excludes).map(c -> (FilterRule)((FilterRule.Builder)FilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FilterRule.Builder> getIncludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.includes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludes(Collection<FilterRule.BuilderImpl> includes) {
            this.includes = FilterListCopier.copyFromBuilder(includes);
        }

        @Override
        public final Builder includes(Collection<FilterRule> includes) {
            this.includes = FilterListCopier.copy(includes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(FilterRule ... includes) {
            this.includes(Arrays.asList(includes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(Consumer<FilterRule.Builder> ... includes) {
            this.includes(Stream.of(includes).map(c -> (FilterRule)((FilterRule.Builder)FilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ManifestConfig.Builder getManifestConfig() {
            return this.manifestConfig != null ? this.manifestConfig.toBuilder() : null;
        }

        public final void setManifestConfig(ManifestConfig.BuilderImpl manifestConfig) {
            this.manifestConfig = manifestConfig != null ? manifestConfig.build() : null;
        }

        @Override
        public final Builder manifestConfig(ManifestConfig manifestConfig) {
            this.manifestConfig = manifestConfig;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getEstimatedFilesToTransfer() {
            return this.estimatedFilesToTransfer;
        }

        public final void setEstimatedFilesToTransfer(Long estimatedFilesToTransfer) {
            this.estimatedFilesToTransfer = estimatedFilesToTransfer;
        }

        @Override
        public final Builder estimatedFilesToTransfer(Long estimatedFilesToTransfer) {
            this.estimatedFilesToTransfer = estimatedFilesToTransfer;
            return this;
        }

        public final Long getEstimatedBytesToTransfer() {
            return this.estimatedBytesToTransfer;
        }

        public final void setEstimatedBytesToTransfer(Long estimatedBytesToTransfer) {
            this.estimatedBytesToTransfer = estimatedBytesToTransfer;
        }

        @Override
        public final Builder estimatedBytesToTransfer(Long estimatedBytesToTransfer) {
            this.estimatedBytesToTransfer = estimatedBytesToTransfer;
            return this;
        }

        public final Long getFilesTransferred() {
            return this.filesTransferred;
        }

        public final void setFilesTransferred(Long filesTransferred) {
            this.filesTransferred = filesTransferred;
        }

        @Override
        public final Builder filesTransferred(Long filesTransferred) {
            this.filesTransferred = filesTransferred;
            return this;
        }

        public final Long getBytesWritten() {
            return this.bytesWritten;
        }

        public final void setBytesWritten(Long bytesWritten) {
            this.bytesWritten = bytesWritten;
        }

        @Override
        public final Builder bytesWritten(Long bytesWritten) {
            this.bytesWritten = bytesWritten;
            return this;
        }

        public final Long getBytesTransferred() {
            return this.bytesTransferred;
        }

        public final void setBytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
        }

        @Override
        public final Builder bytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
            return this;
        }

        public final Long getBytesCompressed() {
            return this.bytesCompressed;
        }

        public final void setBytesCompressed(Long bytesCompressed) {
            this.bytesCompressed = bytesCompressed;
        }

        @Override
        public final Builder bytesCompressed(Long bytesCompressed) {
            this.bytesCompressed = bytesCompressed;
            return this;
        }

        public final TaskExecutionResultDetail.Builder getResult() {
            return this.result != null ? this.result.toBuilder() : null;
        }

        public final void setResult(TaskExecutionResultDetail.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public final Builder result(TaskExecutionResultDetail result) {
            this.result = result;
            return this;
        }

        public final TaskReportConfig.Builder getTaskReportConfig() {
            return this.taskReportConfig != null ? this.taskReportConfig.toBuilder() : null;
        }

        public final void setTaskReportConfig(TaskReportConfig.BuilderImpl taskReportConfig) {
            this.taskReportConfig = taskReportConfig != null ? taskReportConfig.build() : null;
        }

        @Override
        public final Builder taskReportConfig(TaskReportConfig taskReportConfig) {
            this.taskReportConfig = taskReportConfig;
            return this;
        }

        public final Long getFilesDeleted() {
            return this.filesDeleted;
        }

        public final void setFilesDeleted(Long filesDeleted) {
            this.filesDeleted = filesDeleted;
        }

        @Override
        public final Builder filesDeleted(Long filesDeleted) {
            this.filesDeleted = filesDeleted;
            return this;
        }

        public final Long getFilesSkipped() {
            return this.filesSkipped;
        }

        public final void setFilesSkipped(Long filesSkipped) {
            this.filesSkipped = filesSkipped;
        }

        @Override
        public final Builder filesSkipped(Long filesSkipped) {
            this.filesSkipped = filesSkipped;
            return this;
        }

        public final Long getFilesVerified() {
            return this.filesVerified;
        }

        public final void setFilesVerified(Long filesVerified) {
            this.filesVerified = filesVerified;
        }

        @Override
        public final Builder filesVerified(Long filesVerified) {
            this.filesVerified = filesVerified;
            return this;
        }

        public final ReportResult.Builder getReportResult() {
            return this.reportResult != null ? this.reportResult.toBuilder() : null;
        }

        public final void setReportResult(ReportResult.BuilderImpl reportResult) {
            this.reportResult = reportResult != null ? reportResult.build() : null;
        }

        @Override
        public final Builder reportResult(ReportResult reportResult) {
            this.reportResult = reportResult;
            return this;
        }

        public final Long getEstimatedFilesToDelete() {
            return this.estimatedFilesToDelete;
        }

        public final void setEstimatedFilesToDelete(Long estimatedFilesToDelete) {
            this.estimatedFilesToDelete = estimatedFilesToDelete;
        }

        @Override
        public final Builder estimatedFilesToDelete(Long estimatedFilesToDelete) {
            this.estimatedFilesToDelete = estimatedFilesToDelete;
            return this;
        }

        public final String getTaskMode() {
            return this.taskMode;
        }

        public final void setTaskMode(String taskMode) {
            this.taskMode = taskMode;
        }

        @Override
        public final Builder taskMode(String taskMode) {
            this.taskMode = taskMode;
            return this;
        }

        @Override
        public final Builder taskMode(TaskMode taskMode) {
            this.taskMode(taskMode == null ? null : taskMode.toString());
            return this;
        }

        public final Long getFilesPrepared() {
            return this.filesPrepared;
        }

        public final void setFilesPrepared(Long filesPrepared) {
            this.filesPrepared = filesPrepared;
        }

        @Override
        public final Builder filesPrepared(Long filesPrepared) {
            this.filesPrepared = filesPrepared;
            return this;
        }

        public final TaskExecutionFilesListedDetail.Builder getFilesListed() {
            return this.filesListed != null ? this.filesListed.toBuilder() : null;
        }

        public final void setFilesListed(TaskExecutionFilesListedDetail.BuilderImpl filesListed) {
            this.filesListed = filesListed != null ? filesListed.build() : null;
        }

        @Override
        public final Builder filesListed(TaskExecutionFilesListedDetail filesListed) {
            this.filesListed = filesListed;
            return this;
        }

        public final TaskExecutionFilesFailedDetail.Builder getFilesFailed() {
            return this.filesFailed != null ? this.filesFailed.toBuilder() : null;
        }

        public final void setFilesFailed(TaskExecutionFilesFailedDetail.BuilderImpl filesFailed) {
            this.filesFailed = filesFailed != null ? filesFailed.build() : null;
        }

        @Override
        public final Builder filesFailed(TaskExecutionFilesFailedDetail filesFailed) {
            this.filesFailed = filesFailed;
            return this;
        }

        @Override
        public DescribeTaskExecutionResponse build() {
            return new DescribeTaskExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTaskExecutionResponse> {
        public Builder taskExecutionArn(String var1);

        public Builder status(String var1);

        public Builder status(TaskExecutionStatus var1);

        public Builder options(Options var1);

        default public Builder options(Consumer<Options.Builder> options) {
            return this.options((Options)((Options.Builder)Options.builder().applyMutation(options)).build());
        }

        public Builder excludes(Collection<FilterRule> var1);

        public Builder excludes(FilterRule ... var1);

        public Builder excludes(Consumer<FilterRule.Builder> ... var1);

        public Builder includes(Collection<FilterRule> var1);

        public Builder includes(FilterRule ... var1);

        public Builder includes(Consumer<FilterRule.Builder> ... var1);

        public Builder manifestConfig(ManifestConfig var1);

        default public Builder manifestConfig(Consumer<ManifestConfig.Builder> manifestConfig) {
            return this.manifestConfig((ManifestConfig)((ManifestConfig.Builder)ManifestConfig.builder().applyMutation(manifestConfig)).build());
        }

        public Builder startTime(Instant var1);

        public Builder estimatedFilesToTransfer(Long var1);

        public Builder estimatedBytesToTransfer(Long var1);

        public Builder filesTransferred(Long var1);

        public Builder bytesWritten(Long var1);

        public Builder bytesTransferred(Long var1);

        public Builder bytesCompressed(Long var1);

        public Builder result(TaskExecutionResultDetail var1);

        default public Builder result(Consumer<TaskExecutionResultDetail.Builder> result) {
            return this.result((TaskExecutionResultDetail)((TaskExecutionResultDetail.Builder)TaskExecutionResultDetail.builder().applyMutation(result)).build());
        }

        public Builder taskReportConfig(TaskReportConfig var1);

        default public Builder taskReportConfig(Consumer<TaskReportConfig.Builder> taskReportConfig) {
            return this.taskReportConfig((TaskReportConfig)((TaskReportConfig.Builder)TaskReportConfig.builder().applyMutation(taskReportConfig)).build());
        }

        public Builder filesDeleted(Long var1);

        public Builder filesSkipped(Long var1);

        public Builder filesVerified(Long var1);

        public Builder reportResult(ReportResult var1);

        default public Builder reportResult(Consumer<ReportResult.Builder> reportResult) {
            return this.reportResult((ReportResult)((ReportResult.Builder)ReportResult.builder().applyMutation(reportResult)).build());
        }

        public Builder estimatedFilesToDelete(Long var1);

        public Builder taskMode(String var1);

        public Builder taskMode(TaskMode var1);

        public Builder filesPrepared(Long var1);

        public Builder filesListed(TaskExecutionFilesListedDetail var1);

        default public Builder filesListed(Consumer<TaskExecutionFilesListedDetail.Builder> filesListed) {
            return this.filesListed((TaskExecutionFilesListedDetail)((TaskExecutionFilesListedDetail.Builder)TaskExecutionFilesListedDetail.builder().applyMutation(filesListed)).build());
        }

        public Builder filesFailed(TaskExecutionFilesFailedDetail var1);

        default public Builder filesFailed(Consumer<TaskExecutionFilesFailedDetail.Builder> filesFailed) {
            return this.filesFailed((TaskExecutionFilesFailedDetail)((TaskExecutionFilesFailedDetail.Builder)TaskExecutionFilesFailedDetail.builder().applyMutation(filesFailed)).build());
        }
    }
}

