/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.Ec2SecurityGroupArnListCopier;
import software.amazon.awssdk.services.datasync.model.FsxProtocol;
import software.amazon.awssdk.services.datasync.model.InputTagListCopier;
import software.amazon.awssdk.services.datasync.model.TagListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLocationFsxOntapRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, CreateLocationFsxOntapRequest> {
    private static final SdkField<FsxProtocol> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Protocol").getter(CreateLocationFsxOntapRequest.getter(CreateLocationFsxOntapRequest::protocol)).setter(CreateLocationFsxOntapRequest.setter(Builder::protocol)).constructor(FsxProtocol::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupArns").getter(CreateLocationFsxOntapRequest.getter(CreateLocationFsxOntapRequest::securityGroupArns)).setter(CreateLocationFsxOntapRequest.setter(Builder::securityGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STORAGE_VIRTUAL_MACHINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageVirtualMachineArn").getter(CreateLocationFsxOntapRequest.getter(CreateLocationFsxOntapRequest::storageVirtualMachineArn)).setter(CreateLocationFsxOntapRequest.setter(Builder::storageVirtualMachineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineArn").build()}).build();
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdirectory").getter(CreateLocationFsxOntapRequest.getter(CreateLocationFsxOntapRequest::subdirectory)).setter(CreateLocationFsxOntapRequest.setter(Builder::subdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()}).build();
    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateLocationFsxOntapRequest.getter(CreateLocationFsxOntapRequest::tags)).setter(CreateLocationFsxOntapRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, SECURITY_GROUP_ARNS_FIELD, STORAGE_VIRTUAL_MACHINE_ARN_FIELD, SUBDIRECTORY_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Protocol", PROTOCOL_FIELD);
            this.put("SecurityGroupArns", SECURITY_GROUP_ARNS_FIELD);
            this.put("StorageVirtualMachineArn", STORAGE_VIRTUAL_MACHINE_ARN_FIELD);
            this.put("Subdirectory", SUBDIRECTORY_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final FsxProtocol protocol;
    private final List<String> securityGroupArns;
    private final String storageVirtualMachineArn;
    private final String subdirectory;
    private final List<TagListEntry> tags;

    private CreateLocationFsxOntapRequest(BuilderImpl builder) {
        super(builder);
        this.protocol = builder.protocol;
        this.securityGroupArns = builder.securityGroupArns;
        this.storageVirtualMachineArn = builder.storageVirtualMachineArn;
        this.subdirectory = builder.subdirectory;
        this.tags = builder.tags;
    }

    public final FsxProtocol protocol() {
        return this.protocol;
    }

    public final boolean hasSecurityGroupArns() {
        return this.securityGroupArns != null && !(this.securityGroupArns instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupArns() {
        return this.securityGroupArns;
    }

    public final String storageVirtualMachineArn() {
        return this.storageVirtualMachineArn;
    }

    public final String subdirectory() {
        return this.subdirectory;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<TagListEntry> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupArns() ? this.securityGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageVirtualMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationFsxOntapRequest)) {
            return false;
        }
        CreateLocationFsxOntapRequest other = (CreateLocationFsxOntapRequest)((Object)obj);
        return Objects.equals(this.protocol(), other.protocol()) && this.hasSecurityGroupArns() == other.hasSecurityGroupArns() && Objects.equals(this.securityGroupArns(), other.securityGroupArns()) && Objects.equals(this.storageVirtualMachineArn(), other.storageVirtualMachineArn()) && Objects.equals(this.subdirectory(), other.subdirectory()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLocationFsxOntapRequest").add("Protocol", (Object)this.protocol()).add("SecurityGroupArns", this.hasSecurityGroupArns() ? this.securityGroupArns() : null).add("StorageVirtualMachineArn", (Object)this.storageVirtualMachineArn()).add("Subdirectory", (Object)this.subdirectory()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "SecurityGroupArns": {
                return Optional.ofNullable(clazz.cast(this.securityGroupArns()));
            }
            case "StorageVirtualMachineArn": {
                return Optional.ofNullable(clazz.cast(this.storageVirtualMachineArn()));
            }
            case "Subdirectory": {
                return Optional.ofNullable(clazz.cast(this.subdirectory()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationFsxOntapRequest, T> g) {
        return obj -> g.apply((CreateLocationFsxOntapRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private FsxProtocol protocol;
        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();
        private String storageVirtualMachineArn;
        private String subdirectory;
        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationFsxOntapRequest model) {
            super(model);
            this.protocol(model.protocol);
            this.securityGroupArns(model.securityGroupArns);
            this.storageVirtualMachineArn(model.storageVirtualMachineArn);
            this.subdirectory(model.subdirectory);
            this.tags(model.tags);
        }

        public final FsxProtocol.Builder getProtocol() {
            return this.protocol != null ? this.protocol.toBuilder() : null;
        }

        public final void setProtocol(FsxProtocol.BuilderImpl protocol) {
            this.protocol = protocol != null ? protocol.build() : null;
        }

        @Override
        public final Builder protocol(FsxProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Collection<String> getSecurityGroupArns() {
            if (this.securityGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupArns;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
        }

        @Override
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupArns(String ... securityGroupArns) {
            this.securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        public final String getStorageVirtualMachineArn() {
            return this.storageVirtualMachineArn;
        }

        public final void setStorageVirtualMachineArn(String storageVirtualMachineArn) {
            this.storageVirtualMachineArn = storageVirtualMachineArn;
        }

        @Override
        public final Builder storageVirtualMachineArn(String storageVirtualMachineArn) {
            this.storageVirtualMachineArn = storageVirtualMachineArn;
            return this;
        }

        public final String getSubdirectory() {
            return this.subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagListEntry)((TagListEntry.Builder)TagListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocationFsxOntapRequest build() {
            return new CreateLocationFsxOntapRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLocationFsxOntapRequest> {
        public Builder protocol(FsxProtocol var1);

        default public Builder protocol(Consumer<FsxProtocol.Builder> protocol) {
            return this.protocol((FsxProtocol)((FsxProtocol.Builder)FsxProtocol.builder().applyMutation(protocol)).build());
        }

        public Builder securityGroupArns(Collection<String> var1);

        public Builder securityGroupArns(String ... var1);

        public Builder storageVirtualMachineArn(String var1);

        public Builder subdirectory(String var1);

        public Builder tags(Collection<TagListEntry> var1);

        public Builder tags(TagListEntry ... var1);

        public Builder tags(Consumer<TagListEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

