/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.AgentStatus;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.EndpointType;
import software.amazon.awssdk.services.datasync.model.Platform;
import software.amazon.awssdk.services.datasync.model.PrivateLinkConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAgentResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeAgentResponse> {
    private static final SdkField<String> AGENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentArn").getter(DescribeAgentResponse.getter(DescribeAgentResponse::agentArn)).setter(DescribeAgentResponse.setter(Builder::agentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeAgentResponse.getter(DescribeAgentResponse::name)).setter(DescribeAgentResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeAgentResponse.getter(DescribeAgentResponse::statusAsString)).setter(DescribeAgentResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_CONNECTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastConnectionTime").getter(DescribeAgentResponse.getter(DescribeAgentResponse::lastConnectionTime)).setter(DescribeAgentResponse.setter(Builder::lastConnectionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastConnectionTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeAgentResponse.getter(DescribeAgentResponse::creationTime)).setter(DescribeAgentResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(DescribeAgentResponse.getter(DescribeAgentResponse::endpointTypeAsString)).setter(DescribeAgentResponse.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<PrivateLinkConfig> PRIVATE_LINK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrivateLinkConfig").getter(DescribeAgentResponse.getter(DescribeAgentResponse::privateLinkConfig)).setter(DescribeAgentResponse.setter(Builder::privateLinkConfig)).constructor(PrivateLinkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateLinkConfig").build()}).build();
    private static final SdkField<Platform> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Platform").getter(DescribeAgentResponse.getter(DescribeAgentResponse::platform)).setter(DescribeAgentResponse.setter(Builder::platform)).constructor(Platform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ARN_FIELD, NAME_FIELD, STATUS_FIELD, LAST_CONNECTION_TIME_FIELD, CREATION_TIME_FIELD, ENDPOINT_TYPE_FIELD, PRIVATE_LINK_CONFIG_FIELD, PLATFORM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AgentArn", AGENT_ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("LastConnectionTime", LAST_CONNECTION_TIME_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("EndpointType", ENDPOINT_TYPE_FIELD);
            this.put("PrivateLinkConfig", PRIVATE_LINK_CONFIG_FIELD);
            this.put("Platform", PLATFORM_FIELD);
        }
    });
    private final String agentArn;
    private final String name;
    private final String status;
    private final Instant lastConnectionTime;
    private final Instant creationTime;
    private final String endpointType;
    private final PrivateLinkConfig privateLinkConfig;
    private final Platform platform;

    private DescribeAgentResponse(BuilderImpl builder) {
        super(builder);
        this.agentArn = builder.agentArn;
        this.name = builder.name;
        this.status = builder.status;
        this.lastConnectionTime = builder.lastConnectionTime;
        this.creationTime = builder.creationTime;
        this.endpointType = builder.endpointType;
        this.privateLinkConfig = builder.privateLinkConfig;
        this.platform = builder.platform;
    }

    public final String agentArn() {
        return this.agentArn;
    }

    public final String name() {
        return this.name;
    }

    public final AgentStatus status() {
        return AgentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastConnectionTime() {
        return this.lastConnectionTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final EndpointType endpointType() {
        return EndpointType.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    public final PrivateLinkConfig privateLinkConfig() {
        return this.privateLinkConfig;
    }

    public final Platform platform() {
        return this.platform;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastConnectionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateLinkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentResponse)) {
            return false;
        }
        DescribeAgentResponse other = (DescribeAgentResponse)((Object)obj);
        return Objects.equals(this.agentArn(), other.agentArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastConnectionTime(), other.lastConnectionTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.privateLinkConfig(), other.privateLinkConfig()) && Objects.equals(this.platform(), other.platform());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAgentResponse").add("AgentArn", (Object)this.agentArn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("LastConnectionTime", (Object)this.lastConnectionTime()).add("CreationTime", (Object)this.creationTime()).add("EndpointType", (Object)this.endpointTypeAsString()).add("PrivateLinkConfig", (Object)this.privateLinkConfig()).add("Platform", (Object)this.platform()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentArn": {
                return Optional.ofNullable(clazz.cast(this.agentArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LastConnectionTime": {
                return Optional.ofNullable(clazz.cast(this.lastConnectionTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "PrivateLinkConfig": {
                return Optional.ofNullable(clazz.cast(this.privateLinkConfig()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAgentResponse, T> g) {
        return obj -> g.apply((DescribeAgentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String agentArn;
        private String name;
        private String status;
        private Instant lastConnectionTime;
        private Instant creationTime;
        private String endpointType;
        private PrivateLinkConfig privateLinkConfig;
        private Platform platform;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentResponse model) {
            super(model);
            this.agentArn(model.agentArn);
            this.name(model.name);
            this.status(model.status);
            this.lastConnectionTime(model.lastConnectionTime);
            this.creationTime(model.creationTime);
            this.endpointType(model.endpointType);
            this.privateLinkConfig(model.privateLinkConfig);
            this.platform(model.platform);
        }

        public final String getAgentArn() {
            return this.agentArn;
        }

        public final void setAgentArn(String agentArn) {
            this.agentArn = agentArn;
        }

        @Override
        public final Builder agentArn(String agentArn) {
            this.agentArn = agentArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastConnectionTime() {
            return this.lastConnectionTime;
        }

        public final void setLastConnectionTime(Instant lastConnectionTime) {
            this.lastConnectionTime = lastConnectionTime;
        }

        @Override
        public final Builder lastConnectionTime(Instant lastConnectionTime) {
            this.lastConnectionTime = lastConnectionTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final PrivateLinkConfig.Builder getPrivateLinkConfig() {
            return this.privateLinkConfig != null ? this.privateLinkConfig.toBuilder() : null;
        }

        public final void setPrivateLinkConfig(PrivateLinkConfig.BuilderImpl privateLinkConfig) {
            this.privateLinkConfig = privateLinkConfig != null ? privateLinkConfig.build() : null;
        }

        @Override
        public final Builder privateLinkConfig(PrivateLinkConfig privateLinkConfig) {
            this.privateLinkConfig = privateLinkConfig;
            return this;
        }

        public final Platform.Builder getPlatform() {
            return this.platform != null ? this.platform.toBuilder() : null;
        }

        public final void setPlatform(Platform.BuilderImpl platform) {
            this.platform = platform != null ? platform.build() : null;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public DescribeAgentResponse build() {
            return new DescribeAgentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAgentResponse> {
        public Builder agentArn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(AgentStatus var1);

        public Builder lastConnectionTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder endpointType(String var1);

        public Builder endpointType(EndpointType var1);

        public Builder privateLinkConfig(PrivateLinkConfig var1);

        default public Builder privateLinkConfig(Consumer<PrivateLinkConfig.Builder> privateLinkConfig) {
            return this.privateLinkConfig((PrivateLinkConfig)((PrivateLinkConfig.Builder)PrivateLinkConfig.builder().applyMutation(privateLinkConfig)).build());
        }

        public Builder platform(Platform var1);

        default public Builder platform(Consumer<Platform.Builder> platform) {
            return this.platform((Platform)((Platform.Builder)Platform.builder().applyMutation(platform)).build());
        }
    }
}

