/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncAsyncClient;
import software.amazon.awssdk.services.datasync.internal.UserAgentUtils;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsResponse;
import software.amazon.awssdk.services.datasync.model.ResourceMetrics;

public class DescribeStorageSystemResourceMetricsPublisher
implements SdkPublisher<DescribeStorageSystemResourceMetricsResponse> {
    private final DataSyncAsyncClient client;
    private final DescribeStorageSystemResourceMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeStorageSystemResourceMetricsPublisher(DataSyncAsyncClient client, DescribeStorageSystemResourceMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeStorageSystemResourceMetricsPublisher(DataSyncAsyncClient client, DescribeStorageSystemResourceMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeStorageSystemResourceMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeStorageSystemResourceMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceMetrics> metrics() {
        Function<DescribeStorageSystemResourceMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metrics() != null) {
                return response.metrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeStorageSystemResourceMetricsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeStorageSystemResourceMetricsResponseFetcher
    implements AsyncPageFetcher<DescribeStorageSystemResourceMetricsResponse> {
        private DescribeStorageSystemResourceMetricsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStorageSystemResourceMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeStorageSystemResourceMetricsResponse> nextPage(DescribeStorageSystemResourceMetricsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStorageSystemResourceMetricsPublisher.this.client.describeStorageSystemResourceMetrics(DescribeStorageSystemResourceMetricsPublisher.this.firstRequest);
            }
            return DescribeStorageSystemResourceMetricsPublisher.this.client.describeStorageSystemResourceMetrics((DescribeStorageSystemResourceMetricsRequest)((Object)DescribeStorageSystemResourceMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

