/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportDestinationS3
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportDestinationS3> {
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdirectory").getter(ReportDestinationS3.getter(ReportDestinationS3::subdirectory)).setter(ReportDestinationS3.setter(Builder::subdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()}).build();
    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketArn").getter(ReportDestinationS3.getter(ReportDestinationS3::s3BucketArn)).setter(ReportDestinationS3.setter(Builder::s3BucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketArn").build()}).build();
    private static final SdkField<String> BUCKET_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketAccessRoleArn").getter(ReportDestinationS3.getter(ReportDestinationS3::bucketAccessRoleArn)).setter(ReportDestinationS3.setter(Builder::bucketAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketAccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBDIRECTORY_FIELD, S3_BUCKET_ARN_FIELD, BUCKET_ACCESS_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String subdirectory;
    private final String s3BucketArn;
    private final String bucketAccessRoleArn;

    private ReportDestinationS3(BuilderImpl builder) {
        this.subdirectory = builder.subdirectory;
        this.s3BucketArn = builder.s3BucketArn;
        this.bucketAccessRoleArn = builder.bucketAccessRoleArn;
    }

    public final String subdirectory() {
        return this.subdirectory;
    }

    public final String s3BucketArn() {
        return this.s3BucketArn;
    }

    public final String bucketAccessRoleArn() {
        return this.bucketAccessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketAccessRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDestinationS3)) {
            return false;
        }
        ReportDestinationS3 other = (ReportDestinationS3)obj;
        return Objects.equals(this.subdirectory(), other.subdirectory()) && Objects.equals(this.s3BucketArn(), other.s3BucketArn()) && Objects.equals(this.bucketAccessRoleArn(), other.bucketAccessRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"ReportDestinationS3").add("Subdirectory", (Object)this.subdirectory()).add("S3BucketArn", (Object)this.s3BucketArn()).add("BucketAccessRoleArn", (Object)this.bucketAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subdirectory": {
                return Optional.ofNullable(clazz.cast(this.subdirectory()));
            }
            case "S3BucketArn": {
                return Optional.ofNullable(clazz.cast(this.s3BucketArn()));
            }
            case "BucketAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.bucketAccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportDestinationS3, T> g) {
        return obj -> g.apply((ReportDestinationS3)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subdirectory;
        private String s3BucketArn;
        private String bucketAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDestinationS3 model) {
            this.subdirectory(model.subdirectory);
            this.s3BucketArn(model.s3BucketArn);
            this.bucketAccessRoleArn(model.bucketAccessRoleArn);
        }

        public final String getSubdirectory() {
            return this.subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getS3BucketArn() {
            return this.s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final String getBucketAccessRoleArn() {
            return this.bucketAccessRoleArn;
        }

        public final void setBucketAccessRoleArn(String bucketAccessRoleArn) {
            this.bucketAccessRoleArn = bucketAccessRoleArn;
        }

        @Override
        public final Builder bucketAccessRoleArn(String bucketAccessRoleArn) {
            this.bucketAccessRoleArn = bucketAccessRoleArn;
            return this;
        }

        public ReportDestinationS3 build() {
            return new ReportDestinationS3(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportDestinationS3> {
        public Builder subdirectory(String var1);

        public Builder s3BucketArn(String var1);

        public Builder bucketAccessRoleArn(String var1);
    }
}

