/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.PhaseStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskExecutionResultDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskExecutionResultDetail> {
    private static final SdkField<Long> PREPARE_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PrepareDuration").getter(TaskExecutionResultDetail.getter(TaskExecutionResultDetail::prepareDuration)).setter(TaskExecutionResultDetail.setter(Builder::prepareDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrepareDuration").build()}).build();
    private static final SdkField<String> PREPARE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrepareStatus").getter(TaskExecutionResultDetail.getter(TaskExecutionResultDetail::prepareStatusAsString)).setter(TaskExecutionResultDetail.setter(Builder::prepareStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrepareStatus").build()}).build();
    private static final SdkField<Long> TOTAL_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalDuration").getter(TaskExecutionResultDetail.getter(TaskExecutionResultDetail::totalDuration)).setter(TaskExecutionResultDetail.setter(Builder::totalDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalDuration").build()}).build();
    private static final SdkField<Long> TRANSFER_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TransferDuration").getter(TaskExecutionResultDetail.getter(TaskExecutionResultDetail::transferDuration)).setter(TaskExecutionResultDetail.setter(Builder::transferDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferDuration").build()}).build();
    private static final SdkField<String> TRANSFER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransferStatus").getter(TaskExecutionResultDetail.getter(TaskExecutionResultDetail::transferStatusAsString)).setter(TaskExecutionResultDetail.setter(Builder::transferStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferStatus").build()}).build();
    private static final SdkField<Long> VERIFY_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VerifyDuration").getter(TaskExecutionResultDetail.getter(TaskExecutionResultDetail::verifyDuration)).setter(TaskExecutionResultDetail.setter(Builder::verifyDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifyDuration").build()}).build();
    private static final SdkField<String> VERIFY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifyStatus").getter(TaskExecutionResultDetail.getter(TaskExecutionResultDetail::verifyStatusAsString)).setter(TaskExecutionResultDetail.setter(Builder::verifyStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifyStatus").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(TaskExecutionResultDetail.getter(TaskExecutionResultDetail::errorCode)).setter(TaskExecutionResultDetail.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorDetail").getter(TaskExecutionResultDetail.getter(TaskExecutionResultDetail::errorDetail)).setter(TaskExecutionResultDetail.setter(Builder::errorDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREPARE_DURATION_FIELD, PREPARE_STATUS_FIELD, TOTAL_DURATION_FIELD, TRANSFER_DURATION_FIELD, TRANSFER_STATUS_FIELD, VERIFY_DURATION_FIELD, VERIFY_STATUS_FIELD, ERROR_CODE_FIELD, ERROR_DETAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long prepareDuration;
    private final String prepareStatus;
    private final Long totalDuration;
    private final Long transferDuration;
    private final String transferStatus;
    private final Long verifyDuration;
    private final String verifyStatus;
    private final String errorCode;
    private final String errorDetail;

    private TaskExecutionResultDetail(BuilderImpl builder) {
        this.prepareDuration = builder.prepareDuration;
        this.prepareStatus = builder.prepareStatus;
        this.totalDuration = builder.totalDuration;
        this.transferDuration = builder.transferDuration;
        this.transferStatus = builder.transferStatus;
        this.verifyDuration = builder.verifyDuration;
        this.verifyStatus = builder.verifyStatus;
        this.errorCode = builder.errorCode;
        this.errorDetail = builder.errorDetail;
    }

    public final Long prepareDuration() {
        return this.prepareDuration;
    }

    public final PhaseStatus prepareStatus() {
        return PhaseStatus.fromValue(this.prepareStatus);
    }

    public final String prepareStatusAsString() {
        return this.prepareStatus;
    }

    public final Long totalDuration() {
        return this.totalDuration;
    }

    public final Long transferDuration() {
        return this.transferDuration;
    }

    public final PhaseStatus transferStatus() {
        return PhaseStatus.fromValue(this.transferStatus);
    }

    public final String transferStatusAsString() {
        return this.transferStatus;
    }

    public final Long verifyDuration() {
        return this.verifyDuration;
    }

    public final PhaseStatus verifyStatus() {
        return PhaseStatus.fromValue(this.verifyStatus);
    }

    public final String verifyStatusAsString() {
        return this.verifyStatus;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String errorDetail() {
        return this.errorDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.prepareDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.prepareStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifyDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifyStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskExecutionResultDetail)) {
            return false;
        }
        TaskExecutionResultDetail other = (TaskExecutionResultDetail)obj;
        return Objects.equals(this.prepareDuration(), other.prepareDuration()) && Objects.equals(this.prepareStatusAsString(), other.prepareStatusAsString()) && Objects.equals(this.totalDuration(), other.totalDuration()) && Objects.equals(this.transferDuration(), other.transferDuration()) && Objects.equals(this.transferStatusAsString(), other.transferStatusAsString()) && Objects.equals(this.verifyDuration(), other.verifyDuration()) && Objects.equals(this.verifyStatusAsString(), other.verifyStatusAsString()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorDetail(), other.errorDetail());
    }

    public final String toString() {
        return ToString.builder((String)"TaskExecutionResultDetail").add("PrepareDuration", (Object)this.prepareDuration()).add("PrepareStatus", (Object)this.prepareStatusAsString()).add("TotalDuration", (Object)this.totalDuration()).add("TransferDuration", (Object)this.transferDuration()).add("TransferStatus", (Object)this.transferStatusAsString()).add("VerifyDuration", (Object)this.verifyDuration()).add("VerifyStatus", (Object)this.verifyStatusAsString()).add("ErrorCode", (Object)this.errorCode()).add("ErrorDetail", (Object)this.errorDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrepareDuration": {
                return Optional.ofNullable(clazz.cast(this.prepareDuration()));
            }
            case "PrepareStatus": {
                return Optional.ofNullable(clazz.cast(this.prepareStatusAsString()));
            }
            case "TotalDuration": {
                return Optional.ofNullable(clazz.cast(this.totalDuration()));
            }
            case "TransferDuration": {
                return Optional.ofNullable(clazz.cast(this.transferDuration()));
            }
            case "TransferStatus": {
                return Optional.ofNullable(clazz.cast(this.transferStatusAsString()));
            }
            case "VerifyDuration": {
                return Optional.ofNullable(clazz.cast(this.verifyDuration()));
            }
            case "VerifyStatus": {
                return Optional.ofNullable(clazz.cast(this.verifyStatusAsString()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorDetail": {
                return Optional.ofNullable(clazz.cast(this.errorDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskExecutionResultDetail, T> g) {
        return obj -> g.apply((TaskExecutionResultDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long prepareDuration;
        private String prepareStatus;
        private Long totalDuration;
        private Long transferDuration;
        private String transferStatus;
        private Long verifyDuration;
        private String verifyStatus;
        private String errorCode;
        private String errorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskExecutionResultDetail model) {
            this.prepareDuration(model.prepareDuration);
            this.prepareStatus(model.prepareStatus);
            this.totalDuration(model.totalDuration);
            this.transferDuration(model.transferDuration);
            this.transferStatus(model.transferStatus);
            this.verifyDuration(model.verifyDuration);
            this.verifyStatus(model.verifyStatus);
            this.errorCode(model.errorCode);
            this.errorDetail(model.errorDetail);
        }

        public final Long getPrepareDuration() {
            return this.prepareDuration;
        }

        @Override
        public final Builder prepareDuration(Long prepareDuration) {
            this.prepareDuration = prepareDuration;
            return this;
        }

        public final void setPrepareDuration(Long prepareDuration) {
            this.prepareDuration = prepareDuration;
        }

        public final String getPrepareStatus() {
            return this.prepareStatus;
        }

        @Override
        public final Builder prepareStatus(String prepareStatus) {
            this.prepareStatus = prepareStatus;
            return this;
        }

        @Override
        public final Builder prepareStatus(PhaseStatus prepareStatus) {
            this.prepareStatus(prepareStatus == null ? null : prepareStatus.toString());
            return this;
        }

        public final void setPrepareStatus(String prepareStatus) {
            this.prepareStatus = prepareStatus;
        }

        public final Long getTotalDuration() {
            return this.totalDuration;
        }

        @Override
        public final Builder totalDuration(Long totalDuration) {
            this.totalDuration = totalDuration;
            return this;
        }

        public final void setTotalDuration(Long totalDuration) {
            this.totalDuration = totalDuration;
        }

        public final Long getTransferDuration() {
            return this.transferDuration;
        }

        @Override
        public final Builder transferDuration(Long transferDuration) {
            this.transferDuration = transferDuration;
            return this;
        }

        public final void setTransferDuration(Long transferDuration) {
            this.transferDuration = transferDuration;
        }

        public final String getTransferStatus() {
            return this.transferStatus;
        }

        @Override
        public final Builder transferStatus(String transferStatus) {
            this.transferStatus = transferStatus;
            return this;
        }

        @Override
        public final Builder transferStatus(PhaseStatus transferStatus) {
            this.transferStatus(transferStatus == null ? null : transferStatus.toString());
            return this;
        }

        public final void setTransferStatus(String transferStatus) {
            this.transferStatus = transferStatus;
        }

        public final Long getVerifyDuration() {
            return this.verifyDuration;
        }

        @Override
        public final Builder verifyDuration(Long verifyDuration) {
            this.verifyDuration = verifyDuration;
            return this;
        }

        public final void setVerifyDuration(Long verifyDuration) {
            this.verifyDuration = verifyDuration;
        }

        public final String getVerifyStatus() {
            return this.verifyStatus;
        }

        @Override
        public final Builder verifyStatus(String verifyStatus) {
            this.verifyStatus = verifyStatus;
            return this;
        }

        @Override
        public final Builder verifyStatus(PhaseStatus verifyStatus) {
            this.verifyStatus(verifyStatus == null ? null : verifyStatus.toString());
            return this;
        }

        public final void setVerifyStatus(String verifyStatus) {
            this.verifyStatus = verifyStatus;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorDetail() {
            return this.errorDetail;
        }

        @Override
        public final Builder errorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public final void setErrorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
        }

        public TaskExecutionResultDetail build() {
            return new TaskExecutionResultDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskExecutionResultDetail> {
        public Builder prepareDuration(Long var1);

        public Builder prepareStatus(String var1);

        public Builder prepareStatus(PhaseStatus var1);

        public Builder totalDuration(Long var1);

        public Builder transferDuration(Long var1);

        public Builder transferStatus(String var1);

        public Builder transferStatus(PhaseStatus var1);

        public Builder verifyDuration(Long var1);

        public Builder verifyStatus(String var1);

        public Builder verifyStatus(PhaseStatus var1);

        public Builder errorCode(String var1);

        public Builder errorDetail(String var1);
    }
}

