/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.Ec2SecurityGroupArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2Config
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2Config> {
    private static final SdkField<String> SUBNET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetArn").getter(Ec2Config.getter(Ec2Config::subnetArn)).setter(Ec2Config.setter(Builder::subnetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArn").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupArns").getter(Ec2Config.getter(Ec2Config::securityGroupArns)).setter(Ec2Config.setter(Builder::securityGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ARN_FIELD, SECURITY_GROUP_ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String subnetArn;
    private final List<String> securityGroupArns;

    private Ec2Config(BuilderImpl builder) {
        this.subnetArn = builder.subnetArn;
        this.securityGroupArns = builder.securityGroupArns;
    }

    public String subnetArn() {
        return this.subnetArn;
    }

    public boolean hasSecurityGroupArns() {
        return this.securityGroupArns != null && !(this.securityGroupArns instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupArns() {
        return this.securityGroupArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2Config)) {
            return false;
        }
        Ec2Config other = (Ec2Config)obj;
        return Objects.equals(this.subnetArn(), other.subnetArn()) && Objects.equals(this.securityGroupArns(), other.securityGroupArns());
    }

    public String toString() {
        return ToString.builder((String)"Ec2Config").add("SubnetArn", (Object)this.subnetArn()).add("SecurityGroupArns", this.securityGroupArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetArn": {
                return Optional.ofNullable(clazz.cast(this.subnetArn()));
            }
            case "SecurityGroupArns": {
                return Optional.ofNullable(clazz.cast(this.securityGroupArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2Config, T> g) {
        return obj -> g.apply((Ec2Config)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetArn;
        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2Config model) {
            this.subnetArn(model.subnetArn);
            this.securityGroupArns(model.securityGroupArns);
        }

        public final String getSubnetArn() {
            return this.subnetArn;
        }

        @Override
        public final Builder subnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
            return this;
        }

        public final void setSubnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
        }

        public final Collection<String> getSecurityGroupArns() {
            return this.securityGroupArns;
        }

        @Override
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupArns(String ... securityGroupArns) {
            this.securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
        }

        public Ec2Config build() {
            return new Ec2Config(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2Config> {
        public Builder subnetArn(String var1);

        public Builder securityGroupArns(Collection<String> var1);

        public Builder securityGroupArns(String ... var1);
    }
}

