/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.Ec2SecurityGroupArnListCopier;
import software.amazon.awssdk.services.datasync.model.InputTagListCopier;
import software.amazon.awssdk.services.datasync.model.TagListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLocationFsxWindowsRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, CreateLocationFsxWindowsRequest> {
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdirectory").getter(CreateLocationFsxWindowsRequest.getter(CreateLocationFsxWindowsRequest::subdirectory)).setter(CreateLocationFsxWindowsRequest.setter(Builder::subdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()}).build();
    private static final SdkField<String> FSX_FILESYSTEM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FsxFilesystemArn").getter(CreateLocationFsxWindowsRequest.getter(CreateLocationFsxWindowsRequest::fsxFilesystemArn)).setter(CreateLocationFsxWindowsRequest.setter(Builder::fsxFilesystemArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FsxFilesystemArn").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupArns").getter(CreateLocationFsxWindowsRequest.getter(CreateLocationFsxWindowsRequest::securityGroupArns)).setter(CreateLocationFsxWindowsRequest.setter(Builder::securityGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateLocationFsxWindowsRequest.getter(CreateLocationFsxWindowsRequest::tags)).setter(CreateLocationFsxWindowsRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("User").getter(CreateLocationFsxWindowsRequest.getter(CreateLocationFsxWindowsRequest::user)).setter(CreateLocationFsxWindowsRequest.setter(Builder::user)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(CreateLocationFsxWindowsRequest.getter(CreateLocationFsxWindowsRequest::domain)).setter(CreateLocationFsxWindowsRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(CreateLocationFsxWindowsRequest.getter(CreateLocationFsxWindowsRequest::password)).setter(CreateLocationFsxWindowsRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBDIRECTORY_FIELD, FSX_FILESYSTEM_ARN_FIELD, SECURITY_GROUP_ARNS_FIELD, TAGS_FIELD, USER_FIELD, DOMAIN_FIELD, PASSWORD_FIELD));
    private final String subdirectory;
    private final String fsxFilesystemArn;
    private final List<String> securityGroupArns;
    private final List<TagListEntry> tags;
    private final String user;
    private final String domain;
    private final String password;

    private CreateLocationFsxWindowsRequest(BuilderImpl builder) {
        super(builder);
        this.subdirectory = builder.subdirectory;
        this.fsxFilesystemArn = builder.fsxFilesystemArn;
        this.securityGroupArns = builder.securityGroupArns;
        this.tags = builder.tags;
        this.user = builder.user;
        this.domain = builder.domain;
        this.password = builder.password;
    }

    public String subdirectory() {
        return this.subdirectory;
    }

    public String fsxFilesystemArn() {
        return this.fsxFilesystemArn;
    }

    public boolean hasSecurityGroupArns() {
        return this.securityGroupArns != null && !(this.securityGroupArns instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupArns() {
        return this.securityGroupArns;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<TagListEntry> tags() {
        return this.tags;
    }

    public String user() {
        return this.user;
    }

    public String domain() {
        return this.domain;
    }

    public String password() {
        return this.password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.fsxFilesystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupArns() ? this.securityGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationFsxWindowsRequest)) {
            return false;
        }
        CreateLocationFsxWindowsRequest other = (CreateLocationFsxWindowsRequest)((Object)obj);
        return Objects.equals(this.subdirectory(), other.subdirectory()) && Objects.equals(this.fsxFilesystemArn(), other.fsxFilesystemArn()) && this.hasSecurityGroupArns() == other.hasSecurityGroupArns() && Objects.equals(this.securityGroupArns(), other.securityGroupArns()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.password(), other.password());
    }

    public String toString() {
        return ToString.builder((String)"CreateLocationFsxWindowsRequest").add("Subdirectory", (Object)this.subdirectory()).add("FsxFilesystemArn", (Object)this.fsxFilesystemArn()).add("SecurityGroupArns", this.hasSecurityGroupArns() ? this.securityGroupArns() : null).add("Tags", this.hasTags() ? this.tags() : null).add("User", (Object)this.user()).add("Domain", (Object)this.domain()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subdirectory": {
                return Optional.ofNullable(clazz.cast(this.subdirectory()));
            }
            case "FsxFilesystemArn": {
                return Optional.ofNullable(clazz.cast(this.fsxFilesystemArn()));
            }
            case "SecurityGroupArns": {
                return Optional.ofNullable(clazz.cast(this.securityGroupArns()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationFsxWindowsRequest, T> g) {
        return obj -> g.apply((CreateLocationFsxWindowsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String subdirectory;
        private String fsxFilesystemArn;
        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();
        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();
        private String user;
        private String domain;
        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationFsxWindowsRequest model) {
            super(model);
            this.subdirectory(model.subdirectory);
            this.fsxFilesystemArn(model.fsxFilesystemArn);
            this.securityGroupArns(model.securityGroupArns);
            this.tags(model.tags);
            this.user(model.user);
            this.domain(model.domain);
            this.password(model.password);
        }

        public final String getSubdirectory() {
            return this.subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        public final String getFsxFilesystemArn() {
            return this.fsxFilesystemArn;
        }

        @Override
        public final Builder fsxFilesystemArn(String fsxFilesystemArn) {
            this.fsxFilesystemArn = fsxFilesystemArn;
            return this;
        }

        public final void setFsxFilesystemArn(String fsxFilesystemArn) {
            this.fsxFilesystemArn = fsxFilesystemArn;
        }

        public final Collection<String> getSecurityGroupArns() {
            if (this.securityGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupArns;
        }

        @Override
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupArns(String ... securityGroupArns) {
            this.securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
        }

        public final Collection<TagListEntry.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(TagListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagListEntry)((TagListEntry.Builder)TagListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        public final String getUser() {
            return this.user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocationFsxWindowsRequest build() {
            return new CreateLocationFsxWindowsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLocationFsxWindowsRequest> {
        public Builder subdirectory(String var1);

        public Builder fsxFilesystemArn(String var1);

        public Builder securityGroupArns(Collection<String> var1);

        public Builder securityGroupArns(String ... var1);

        public Builder tags(Collection<TagListEntry> var1);

        public Builder tags(TagListEntry ... var1);

        public Builder tags(Consumer<TagListEntry.Builder> ... var1);

        public Builder user(String var1);

        public Builder domain(String var1);

        public Builder password(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

