/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.InputTagListCopier;
import software.amazon.awssdk.services.datasync.model.PLSecurityGroupArnListCopier;
import software.amazon.awssdk.services.datasync.model.PLSubnetArnListCopier;
import software.amazon.awssdk.services.datasync.model.TagListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAgentRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, CreateAgentRequest> {
    private static final SdkField<String> ACTIVATION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivationKey").getter(CreateAgentRequest.getter(CreateAgentRequest::activationKey)).setter(CreateAgentRequest.setter(Builder::activationKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationKey").build()}).build();
    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentName").getter(CreateAgentRequest.getter(CreateAgentRequest::agentName)).setter(CreateAgentRequest.setter(Builder::agentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentName").build()}).build();
    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateAgentRequest.getter(CreateAgentRequest::tags)).setter(CreateAgentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(CreateAgentRequest.getter(CreateAgentRequest::vpcEndpointId)).setter(CreateAgentRequest.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()}).build();
    private static final SdkField<List<String>> SUBNET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetArns").getter(CreateAgentRequest.getter(CreateAgentRequest::subnetArns)).setter(CreateAgentRequest.setter(Builder::subnetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupArns").getter(CreateAgentRequest.getter(CreateAgentRequest::securityGroupArns)).setter(CreateAgentRequest.setter(Builder::securityGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_KEY_FIELD, AGENT_NAME_FIELD, TAGS_FIELD, VPC_ENDPOINT_ID_FIELD, SUBNET_ARNS_FIELD, SECURITY_GROUP_ARNS_FIELD));
    private final String activationKey;
    private final String agentName;
    private final List<TagListEntry> tags;
    private final String vpcEndpointId;
    private final List<String> subnetArns;
    private final List<String> securityGroupArns;

    private CreateAgentRequest(BuilderImpl builder) {
        super(builder);
        this.activationKey = builder.activationKey;
        this.agentName = builder.agentName;
        this.tags = builder.tags;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.subnetArns = builder.subnetArns;
        this.securityGroupArns = builder.securityGroupArns;
    }

    public String activationKey() {
        return this.activationKey;
    }

    public String agentName() {
        return this.agentName;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<TagListEntry> tags() {
        return this.tags;
    }

    public String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public boolean hasSubnetArns() {
        return this.subnetArns != null && !(this.subnetArns instanceof SdkAutoConstructList);
    }

    public List<String> subnetArns() {
        return this.subnetArns;
    }

    public boolean hasSecurityGroupArns() {
        return this.securityGroupArns != null && !(this.securityGroupArns instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupArns() {
        return this.securityGroupArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.activationKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentRequest)) {
            return false;
        }
        CreateAgentRequest other = (CreateAgentRequest)((Object)obj);
        return Objects.equals(this.activationKey(), other.activationKey()) && Objects.equals(this.agentName(), other.agentName()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.subnetArns(), other.subnetArns()) && Objects.equals(this.securityGroupArns(), other.securityGroupArns());
    }

    public String toString() {
        return ToString.builder((String)"CreateAgentRequest").add("ActivationKey", (Object)this.activationKey()).add("AgentName", (Object)this.agentName()).add("Tags", this.tags()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("SubnetArns", this.subnetArns()).add("SecurityGroupArns", this.securityGroupArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivationKey": {
                return Optional.ofNullable(clazz.cast(this.activationKey()));
            }
            case "AgentName": {
                return Optional.ofNullable(clazz.cast(this.agentName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "SubnetArns": {
                return Optional.ofNullable(clazz.cast(this.subnetArns()));
            }
            case "SecurityGroupArns": {
                return Optional.ofNullable(clazz.cast(this.securityGroupArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentRequest, T> g) {
        return obj -> g.apply((CreateAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String activationKey;
        private String agentName;
        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();
        private String vpcEndpointId;
        private List<String> subnetArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentRequest model) {
            super(model);
            this.activationKey(model.activationKey);
            this.agentName(model.agentName);
            this.tags(model.tags);
            this.vpcEndpointId(model.vpcEndpointId);
            this.subnetArns(model.subnetArns);
            this.securityGroupArns(model.securityGroupArns);
        }

        public final String getActivationKey() {
            return this.activationKey;
        }

        @Override
        public final Builder activationKey(String activationKey) {
            this.activationKey = activationKey;
            return this;
        }

        public final void setActivationKey(String activationKey) {
            this.activationKey = activationKey;
        }

        public final String getAgentName() {
            return this.agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        public final Collection<TagListEntry.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(TagListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagListEntry)((TagListEntry.Builder)TagListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final Collection<String> getSubnetArns() {
            return this.subnetArns;
        }

        @Override
        public final Builder subnetArns(Collection<String> subnetArns) {
            this.subnetArns = PLSubnetArnListCopier.copy(subnetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetArns(String ... subnetArns) {
            this.subnetArns(Arrays.asList(subnetArns));
            return this;
        }

        public final void setSubnetArns(Collection<String> subnetArns) {
            this.subnetArns = PLSubnetArnListCopier.copy(subnetArns);
        }

        public final Collection<String> getSecurityGroupArns() {
            return this.securityGroupArns;
        }

        @Override
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = PLSecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupArns(String ... securityGroupArns) {
            this.securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = PLSecurityGroupArnListCopier.copy(securityGroupArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAgentRequest build() {
            return new CreateAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAgentRequest> {
        public Builder activationKey(String var1);

        public Builder agentName(String var1);

        public Builder tags(Collection<TagListEntry> var1);

        public Builder tags(TagListEntry ... var1);

        public Builder tags(Consumer<TagListEntry.Builder> ... var1);

        public Builder vpcEndpointId(String var1);

        public Builder subnetArns(Collection<String> var1);

        public Builder subnetArns(String ... var1);

        public Builder securityGroupArns(Collection<String> var1);

        public Builder securityGroupArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

