/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum S3StorageClass {
    STANDARD("STANDARD"),
    STANDARD_IA("STANDARD_IA"),
    ONEZONE_IA("ONEZONE_IA"),
    INTELLIGENT_TIERING("INTELLIGENT_TIERING"),
    GLACIER("GLACIER"),
    DEEP_ARCHIVE("DEEP_ARCHIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private S3StorageClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3StorageClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(S3StorageClass.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3StorageClass> knownValues() {
        return Stream.of(S3StorageClass.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

