/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncClient;
import software.amazon.awssdk.services.datasync.model.ListAgentsRequest;
import software.amazon.awssdk.services.datasync.model.ListAgentsResponse;

public class ListAgentsIterable
implements SdkIterable<ListAgentsResponse> {
    private final DataSyncClient client;
    private final ListAgentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAgentsIterable(DataSyncClient client, ListAgentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAgentsResponseFetcher();
    }

    public Iterator<ListAgentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListAgentsIterable resume(ListAgentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAgentsIterable(this.client, (ListAgentsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListAgentsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListAgentsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListAgentsResponseFetcher
    implements SyncPageFetcher<ListAgentsResponse> {
        private ListAgentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAgentsResponse nextPage(ListAgentsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentsIterable.this.client.listAgents(ListAgentsIterable.this.firstRequest);
            }
            return ListAgentsIterable.this.client.listAgents((ListAgentsRequest)((Object)ListAgentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

