/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of ListPipelines.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPipelinesResponse extends DataPipelineResponse implements
        ToCopyableBuilder<ListPipelinesResponse.Builder, ListPipelinesResponse> {
    private static final SdkField<List<PipelineIdName>> PIPELINE_ID_LIST_FIELD = SdkField
            .<List<PipelineIdName>> builder(MarshallingType.LIST)
            .memberName("pipelineIdList")
            .getter(getter(ListPipelinesResponse::pipelineIdList))
            .setter(setter(Builder::pipelineIdList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineIdList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineIdName> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineIdName::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("marker")
            .getter(getter(ListPipelinesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marker").build()).build();

    private static final SdkField<Boolean> HAS_MORE_RESULTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hasMoreResults").getter(getter(ListPipelinesResponse::hasMoreResults))
            .setter(setter(Builder::hasMoreResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasMoreResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_LIST_FIELD,
            MARKER_FIELD, HAS_MORE_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PipelineIdName> pipelineIdList;

    private final String marker;

    private final Boolean hasMoreResults;

    private ListPipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineIdList = builder.pipelineIdList;
        this.marker = builder.marker;
        this.hasMoreResults = builder.hasMoreResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the PipelineIdList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPipelineIdList() {
        return pipelineIdList != null && !(pipelineIdList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The pipeline identifiers. If you require additional information about the pipelines, you can use these
     * identifiers to call <a>DescribePipelines</a> and <a>GetPipelineDefinition</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPipelineIdList} method.
     * </p>
     * 
     * @return The pipeline identifiers. If you require additional information about the pipelines, you can use these
     *         identifiers to call <a>DescribePipelines</a> and <a>GetPipelineDefinition</a>.
     */
    public final List<PipelineIdName> pipelineIdList() {
        return pipelineIdList;
    }

    /**
     * <p>
     * The starting point for the next page of results. To view the next page of results, call
     * <code>ListPipelinesOutput</code> again with this marker value. If the value is null, there are no more results.
     * </p>
     * 
     * @return The starting point for the next page of results. To view the next page of results, call
     *         <code>ListPipelinesOutput</code> again with this marker value. If the value is null, there are no more
     *         results.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * Indicates whether there are more results that can be obtained by a subsequent call.
     * </p>
     * 
     * @return Indicates whether there are more results that can be obtained by a subsequent call.
     */
    public final Boolean hasMoreResults() {
        return hasMoreResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineIdList() ? pipelineIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasMoreResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResponse)) {
            return false;
        }
        ListPipelinesResponse other = (ListPipelinesResponse) obj;
        return hasPipelineIdList() == other.hasPipelineIdList() && Objects.equals(pipelineIdList(), other.pipelineIdList())
                && Objects.equals(marker(), other.marker()) && Objects.equals(hasMoreResults(), other.hasMoreResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPipelinesResponse").add("PipelineIdList", hasPipelineIdList() ? pipelineIdList() : null)
                .add("Marker", marker()).add("HasMoreResults", hasMoreResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineIdList":
            return Optional.ofNullable(clazz.cast(pipelineIdList()));
        case "marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "hasMoreResults":
            return Optional.ofNullable(clazz.cast(hasMoreResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pipelineIdList", PIPELINE_ID_LIST_FIELD);
        map.put("marker", MARKER_FIELD);
        map.put("hasMoreResults", HAS_MORE_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPipelinesResponse, T> g) {
        return obj -> g.apply((ListPipelinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataPipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPipelinesResponse> {
        /**
         * <p>
         * The pipeline identifiers. If you require additional information about the pipelines, you can use these
         * identifiers to call <a>DescribePipelines</a> and <a>GetPipelineDefinition</a>.
         * </p>
         * 
         * @param pipelineIdList
         *        The pipeline identifiers. If you require additional information about the pipelines, you can use these
         *        identifiers to call <a>DescribePipelines</a> and <a>GetPipelineDefinition</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineIdList(Collection<PipelineIdName> pipelineIdList);

        /**
         * <p>
         * The pipeline identifiers. If you require additional information about the pipelines, you can use these
         * identifiers to call <a>DescribePipelines</a> and <a>GetPipelineDefinition</a>.
         * </p>
         * 
         * @param pipelineIdList
         *        The pipeline identifiers. If you require additional information about the pipelines, you can use these
         *        identifiers to call <a>DescribePipelines</a> and <a>GetPipelineDefinition</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineIdList(PipelineIdName... pipelineIdList);

        /**
         * <p>
         * The pipeline identifiers. If you require additional information about the pipelines, you can use these
         * identifiers to call <a>DescribePipelines</a> and <a>GetPipelineDefinition</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datapipeline.model.PipelineIdName.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datapipeline.model.PipelineIdName#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datapipeline.model.PipelineIdName.Builder#build()} is called
         * immediately and its result is passed to {@link #pipelineIdList(List<PipelineIdName>)}.
         * 
         * @param pipelineIdList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datapipeline.model.PipelineIdName.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineIdList(java.util.Collection<PipelineIdName>)
         */
        Builder pipelineIdList(Consumer<PipelineIdName.Builder>... pipelineIdList);

        /**
         * <p>
         * The starting point for the next page of results. To view the next page of results, call
         * <code>ListPipelinesOutput</code> again with this marker value. If the value is null, there are no more
         * results.
         * </p>
         * 
         * @param marker
         *        The starting point for the next page of results. To view the next page of results, call
         *        <code>ListPipelinesOutput</code> again with this marker value. If the value is null, there are no more
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Indicates whether there are more results that can be obtained by a subsequent call.
         * </p>
         * 
         * @param hasMoreResults
         *        Indicates whether there are more results that can be obtained by a subsequent call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreResults(Boolean hasMoreResults);
    }

    static final class BuilderImpl extends DataPipelineResponse.BuilderImpl implements Builder {
        private List<PipelineIdName> pipelineIdList = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Boolean hasMoreResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelinesResponse model) {
            super(model);
            pipelineIdList(model.pipelineIdList);
            marker(model.marker);
            hasMoreResults(model.hasMoreResults);
        }

        public final List<PipelineIdName.Builder> getPipelineIdList() {
            List<PipelineIdName.Builder> result = _pipelineListCopier.copyToBuilder(this.pipelineIdList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineIdList(Collection<PipelineIdName.BuilderImpl> pipelineIdList) {
            this.pipelineIdList = _pipelineListCopier.copyFromBuilder(pipelineIdList);
        }

        @Override
        public final Builder pipelineIdList(Collection<PipelineIdName> pipelineIdList) {
            this.pipelineIdList = _pipelineListCopier.copy(pipelineIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIdList(PipelineIdName... pipelineIdList) {
            pipelineIdList(Arrays.asList(pipelineIdList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIdList(Consumer<PipelineIdName.Builder>... pipelineIdList) {
            pipelineIdList(Stream.of(pipelineIdList).map(c -> PipelineIdName.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Boolean getHasMoreResults() {
            return hasMoreResults;
        }

        public final void setHasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
        }

        @Override
        public final Builder hasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
            return this;
        }

        @Override
        public ListPipelinesResponse build() {
            return new ListPipelinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
