/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.PipelineObject;
import software.amazon.awssdk.services.datapipeline.model.PipelineObjectListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeObjectsResponse
extends DataPipelineResponse
implements ToCopyableBuilder<Builder, DescribeObjectsResponse> {
    private static final SdkField<List<PipelineObject>> PIPELINE_OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeObjectsResponse.getter(DescribeObjectsResponse::pipelineObjects)).setter(DescribeObjectsResponse.setter(Builder::pipelineObjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineObjects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeObjectsResponse.getter(DescribeObjectsResponse::marker)).setter(DescribeObjectsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marker").build()}).build();
    private static final SdkField<Boolean> HAS_MORE_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeObjectsResponse.getter(DescribeObjectsResponse::hasMoreResults)).setter(DescribeObjectsResponse.setter(Builder::hasMoreResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasMoreResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_OBJECTS_FIELD, MARKER_FIELD, HAS_MORE_RESULTS_FIELD));
    private final List<PipelineObject> pipelineObjects;
    private final String marker;
    private final Boolean hasMoreResults;

    private DescribeObjectsResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineObjects = builder.pipelineObjects;
        this.marker = builder.marker;
        this.hasMoreResults = builder.hasMoreResults;
    }

    public List<PipelineObject> pipelineObjects() {
        return this.pipelineObjects;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean hasMoreResults() {
        return this.hasMoreResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineObjects());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeObjectsResponse)) {
            return false;
        }
        DescribeObjectsResponse other = (DescribeObjectsResponse)((Object)obj);
        return Objects.equals(this.pipelineObjects(), other.pipelineObjects()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.hasMoreResults(), other.hasMoreResults());
    }

    public String toString() {
        return ToString.builder((String)"DescribeObjectsResponse").add("PipelineObjects", this.pipelineObjects()).add("Marker", (Object)this.marker()).add("HasMoreResults", (Object)this.hasMoreResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineObjects": {
                return Optional.ofNullable(clazz.cast(this.pipelineObjects()));
            }
            case "marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "hasMoreResults": {
                return Optional.ofNullable(clazz.cast(this.hasMoreResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeObjectsResponse, T> g) {
        return obj -> g.apply((DescribeObjectsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineResponse.BuilderImpl
    implements Builder {
        private List<PipelineObject> pipelineObjects = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Boolean hasMoreResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeObjectsResponse model) {
            super(model);
            this.pipelineObjects(model.pipelineObjects);
            this.marker(model.marker);
            this.hasMoreResults(model.hasMoreResults);
        }

        public final Collection<PipelineObject.Builder> getPipelineObjects() {
            return this.pipelineObjects != null ? (Collection)this.pipelineObjects.stream().map(PipelineObject::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelineObjects(Collection<PipelineObject> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copy(pipelineObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(PipelineObject ... pipelineObjects) {
            this.pipelineObjects(Arrays.asList(pipelineObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(Consumer<PipelineObject.Builder> ... pipelineObjects) {
            this.pipelineObjects(Stream.of(pipelineObjects).map(c -> (PipelineObject)((PipelineObject.Builder)PipelineObject.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineObjects(Collection<PipelineObject.BuilderImpl> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copyFromBuilder(pipelineObjects);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getHasMoreResults() {
            return this.hasMoreResults;
        }

        @Override
        public final Builder hasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
            return this;
        }

        public final void setHasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
        }

        @Override
        public DescribeObjectsResponse build() {
            return new DescribeObjectsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataPipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeObjectsResponse> {
        public Builder pipelineObjects(Collection<PipelineObject> var1);

        public Builder pipelineObjects(PipelineObject ... var1);

        public Builder pipelineObjects(Consumer<PipelineObject.Builder> ... var1);

        public Builder marker(String var1);

        public Builder hasMoreResults(Boolean var1);
    }
}

