/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Field
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Field> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(Field.getter(Field::key)).setter(Field.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(Field.getter(Field::stringValue)).setter(Field.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final SdkField<String> REF_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("refValue").getter(Field.getter(Field::refValue)).setter(Field.setter(Builder::refValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, STRING_VALUE_FIELD, REF_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Field.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String key;
    private final String stringValue;
    private final String refValue;

    private Field(BuilderImpl builder) {
        this.key = builder.key;
        this.stringValue = builder.stringValue;
        this.refValue = builder.refValue;
    }

    public final String key() {
        return this.key;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final String refValue() {
        return this.refValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.refValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.refValue(), other.refValue());
    }

    public final String toString() {
        return ToString.builder((String)"Field").add("Key", (Object)this.key()).add("StringValue", (Object)this.stringValue()).add("RefValue", (Object)this.refValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "refValue": {
                return Optional.ofNullable(clazz.cast(this.refValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("key", KEY_FIELD);
        map.put("stringValue", STRING_VALUE_FIELD);
        map.put("refValue", REF_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Field, T> g) {
        return obj -> g.apply((Field)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String stringValue;
        private String refValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Field model) {
            this.key(model.key);
            this.stringValue(model.stringValue);
            this.refValue(model.refValue);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final String getRefValue() {
            return this.refValue;
        }

        public final void setRefValue(String refValue) {
            this.refValue = refValue;
        }

        @Override
        public final Builder refValue(String refValue) {
            this.refValue = refValue;
            return this;
        }

        public Field build() {
            return new Field(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Field> {
        public Builder key(String var1);

        public Builder stringValue(String var1);

        public Builder refValue(String var1);
    }
}

