/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.endpoints.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionScope;
import software.amazon.awssdk.services.datapipeline.endpoints.internal.Identifier;
import software.amazon.awssdk.services.datapipeline.endpoints.internal.Value;
import software.amazon.awssdk.utils.Logger;

@SdkProtectedApi
public final class AuthSchemeUtils {
    private static final Logger LOG = Logger.loggerFor(AuthSchemeUtils.class);
    private static final String SIGV4_NAME = "sigv4";
    private static final String SIGV4A_NAME = "sigv4a";
    private static final Set<String> KNOWN_AUTH_SCHEMES;

    private AuthSchemeUtils() {
    }

    public static EndpointAuthScheme chooseAuthScheme(List<EndpointAuthScheme> authSchemes) {
        for (EndpointAuthScheme authScheme : authSchemes) {
            if (!KNOWN_AUTH_SCHEMES.contains(authScheme.name())) continue;
            return authScheme;
        }
        throw SdkClientException.create((String)("Endpoint did not contain any known auth schemes: " + authSchemes));
    }

    public static List<EndpointAuthScheme> createAuthSchemes(Value authSchemesValue) {
        Value.Array schemesArray = authSchemesValue.expectArray();
        ArrayList<EndpointAuthScheme> authSchemes = new ArrayList<EndpointAuthScheme>();
        block8: for (int i = 0; i < schemesArray.size(); ++i) {
            String authSchemeName;
            Value.Record scheme = schemesArray.get(i).expectRecord();
            switch (authSchemeName = scheme.get(Identifier.of("name")).expectString()) {
                case "sigv4a": {
                    Value disableDoubleEncoding;
                    Value signingRegionSet;
                    SigV4aAuthScheme.Builder schemeBuilder = SigV4aAuthScheme.builder();
                    Value signingName = scheme.get(Identifier.of("signingName"));
                    if (signingName != null) {
                        schemeBuilder.signingName(signingName.expectString());
                    }
                    if ((signingRegionSet = scheme.get(Identifier.of("signingRegionSet"))) != null) {
                        Value.Array signingRegionSetArray = signingRegionSet.expectArray();
                        for (int j = 0; j < signingRegionSetArray.size(); ++j) {
                            schemeBuilder.addSigningRegion(signingRegionSetArray.get(j).expectString());
                        }
                    }
                    if ((disableDoubleEncoding = scheme.get(Identifier.of("disableDoubleEncoding"))) != null) {
                        schemeBuilder.disableDoubleEncoding(Boolean.valueOf(disableDoubleEncoding.expectBool()));
                    }
                    authSchemes.add((EndpointAuthScheme)schemeBuilder.build());
                    continue block8;
                }
                case "sigv4": {
                    Value signingRegion;
                    Value disableDoubleEncoding;
                    SigV4aAuthScheme.Builder schemeBuilder = SigV4AuthScheme.builder();
                    Value signingName = scheme.get(Identifier.of("signingName"));
                    if (signingName != null) {
                        schemeBuilder.signingName(signingName.expectString());
                    }
                    if ((signingRegion = scheme.get(Identifier.of("signingRegion"))) != null) {
                        schemeBuilder.signingRegion(signingRegion.expectString());
                    }
                    if ((disableDoubleEncoding = scheme.get(Identifier.of("disableDoubleEncoding"))) != null) {
                        schemeBuilder.disableDoubleEncoding(Boolean.valueOf(disableDoubleEncoding.expectBool()));
                    }
                    authSchemes.add((EndpointAuthScheme)schemeBuilder.build());
                    continue block8;
                }
                default: {
                    LOG.debug(() -> "Ignoring unknown auth scheme: " + authSchemeName);
                }
            }
        }
        return authSchemes;
    }

    public static void setSigningParams(ExecutionAttributes executionAttributes, EndpointAuthScheme authScheme) {
        if (authScheme instanceof SigV4AuthScheme) {
            AuthSchemeUtils.setSigV4SigningParams(executionAttributes, (SigV4AuthScheme)authScheme);
        } else if (authScheme instanceof SigV4aAuthScheme) {
            AuthSchemeUtils.setSigV4aAuthSigningParams(executionAttributes, (SigV4aAuthScheme)authScheme);
        } else {
            throw SdkClientException.create((String)("Don't know how to set signing params for auth scheme: " + authScheme.name()));
        }
    }

    private static void setSigV4SigningParams(ExecutionAttributes executionAttributes, SigV4AuthScheme sigV4AuthScheme) {
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNER_DOUBLE_URL_ENCODE, (Object)(!sigV4AuthScheme.disableDoubleEncoding() ? 1 : 0));
        if (sigV4AuthScheme.signingName() != null) {
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, (Object)sigV4AuthScheme.signingName());
        }
        if (sigV4AuthScheme.signingRegion() != null) {
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, (Object)Region.of((String)sigV4AuthScheme.signingRegion()));
        }
    }

    private static void setSigV4aAuthSigningParams(ExecutionAttributes executionAttributes, SigV4aAuthScheme sigV4aAuthScheme) {
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNER_DOUBLE_URL_ENCODE, (Object)(!sigV4aAuthScheme.disableDoubleEncoding() ? 1 : 0));
        if (sigV4aAuthScheme.signingName() != null) {
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, (Object)sigV4aAuthScheme.signingName());
        }
        if (sigV4aAuthScheme.signingRegionSet() != null) {
            if (sigV4aAuthScheme.signingRegionSet().size() > 1) {
                throw SdkClientException.create((String)"Don't know how to set scope of > 1 region");
            }
            if (sigV4aAuthScheme.signingRegionSet().isEmpty()) {
                throw SdkClientException.create((String)"Signing region set is empty");
            }
            String scope = (String)sigV4aAuthScheme.signingRegionSet().get(0);
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION_SCOPE, (Object)RegionScope.create((String)scope));
        }
    }

    static {
        HashSet<String> schemes = new HashSet<String>();
        schemes.add(SIGV4_NAME);
        schemes.add(SIGV4A_NAME);
        KNOWN_AUTH_SCHEMES = Collections.unmodifiableSet(schemes);
    }
}

