/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datapipeline.model._validationMessagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidationWarning
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidationWarning> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ValidationWarning.getter(ValidationWarning::id)).setter(ValidationWarning.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<String>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("warnings").getter(ValidationWarning.getter(ValidationWarning::warnings)).setter(ValidationWarning.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, WARNINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<String> warnings;

    private ValidationWarning(BuilderImpl builder) {
        this.id = builder.id;
        this.warnings = builder.warnings;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasWarnings() {
        return this.warnings != null && !(this.warnings instanceof SdkAutoConstructList);
    }

    public final List<String> warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWarnings() ? this.warnings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationWarning)) {
            return false;
        }
        ValidationWarning other = (ValidationWarning)obj;
        return Objects.equals(this.id(), other.id()) && this.hasWarnings() == other.hasWarnings() && Objects.equals(this.warnings(), other.warnings());
    }

    public final String toString() {
        return ToString.builder((String)"ValidationWarning").add("Id", (Object)this.id()).add("Warnings", this.hasWarnings() ? this.warnings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationWarning, T> g) {
        return obj -> g.apply((ValidationWarning)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<String> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationWarning model) {
            this.id(model.id);
            this.warnings(model.warnings);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getWarnings() {
            if (this.warnings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.warnings;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = _validationMessagesCopier.copy(warnings);
        }

        @Override
        @Transient
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = _validationMessagesCopier.copy(warnings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder warnings(String ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        public ValidationWarning build() {
            return new ValidationWarning(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidationWarning> {
        public Builder id(String var1);

        public Builder warnings(Collection<String> var1);

        public Builder warnings(String ... var1);
    }
}

