/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateExpressionRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, EvaluateExpressionRequest> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineId").getter(EvaluateExpressionRequest.getter(EvaluateExpressionRequest::pipelineId)).setter(EvaluateExpressionRequest.setter(Builder::pipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()}).build();
    private static final SdkField<String> OBJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("objectId").getter(EvaluateExpressionRequest.getter(EvaluateExpressionRequest::objectId)).setter(EvaluateExpressionRequest.setter(Builder::objectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectId").build()}).build();
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expression").getter(EvaluateExpressionRequest.getter(EvaluateExpressionRequest::expression)).setter(EvaluateExpressionRequest.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD, OBJECT_ID_FIELD, EXPRESSION_FIELD));
    private final String pipelineId;
    private final String objectId;
    private final String expression;

    private EvaluateExpressionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.objectId = builder.objectId;
        this.expression = builder.expression;
    }

    public final String pipelineId() {
        return this.pipelineId;
    }

    public final String objectId() {
        return this.objectId;
    }

    public final String expression() {
        return this.expression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateExpressionRequest)) {
            return false;
        }
        EvaluateExpressionRequest other = (EvaluateExpressionRequest)((Object)obj);
        return Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.objectId(), other.objectId()) && Objects.equals(this.expression(), other.expression());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateExpressionRequest").add("PipelineId", (Object)this.pipelineId()).add("ObjectId", (Object)this.objectId()).add("Expression", (Object)this.expression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.ofNullable(clazz.cast(this.pipelineId()));
            }
            case "objectId": {
                return Optional.ofNullable(clazz.cast(this.objectId()));
            }
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluateExpressionRequest, T> g) {
        return obj -> g.apply((EvaluateExpressionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineId;
        private String objectId;
        private String expression;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateExpressionRequest model) {
            super(model);
            this.pipelineId(model.pipelineId);
            this.objectId(model.objectId);
            this.expression(model.expression);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final String getObjectId() {
            return this.objectId;
        }

        @Override
        public final Builder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public final void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public final String getExpression() {
            return this.expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EvaluateExpressionRequest build() {
            return new EvaluateExpressionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EvaluateExpressionRequest> {
        public Builder pipelineId(String var1);

        public Builder objectId(String var1);

        public Builder expression(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

