/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetPipelineDefinitionRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, GetPipelineDefinitionRequest> {
    private final String pipelineId;
    private final String version;

    private GetPipelineDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.version = builder.version;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public String version() {
        return this.version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineDefinitionRequest)) {
            return false;
        }
        GetPipelineDefinitionRequest other = (GetPipelineDefinitionRequest)((Object)obj);
        return Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"GetPipelineDefinitionRequest").add("PipelineId", (Object)this.pipelineId()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.of(clazz.cast(this.pipelineId()));
            }
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineId;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineDefinitionRequest model) {
            this.pipelineId(model.pipelineId);
            this.version(model.version);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetPipelineDefinitionRequest build() {
            return new GetPipelineDefinitionRequest(this);
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    CopyableBuilder<Builder, GetPipelineDefinitionRequest> {
        public Builder pipelineId(String var1);

        public Builder version(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

