/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.datapipeline.DataPipelineClient;
import software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.ActivatePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.AddTagsRequest;
import software.amazon.awssdk.services.datapipeline.model.AddTagsResponse;
import software.amazon.awssdk.services.datapipeline.model.CreatePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.CreatePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineException;
import software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.DeletePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.DeletePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse;
import software.amazon.awssdk.services.datapipeline.model.DescribePipelinesRequest;
import software.amazon.awssdk.services.datapipeline.model.DescribePipelinesResponse;
import software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionRequest;
import software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionResponse;
import software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionRequest;
import software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionResponse;
import software.amazon.awssdk.services.datapipeline.model.InternalServiceErrorException;
import software.amazon.awssdk.services.datapipeline.model.InvalidRequestException;
import software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest;
import software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse;
import software.amazon.awssdk.services.datapipeline.model.PipelineDeletedException;
import software.amazon.awssdk.services.datapipeline.model.PipelineNotFoundException;
import software.amazon.awssdk.services.datapipeline.model.PollForTaskRequest;
import software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse;
import software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionRequest;
import software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionResponse;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse;
import software.amazon.awssdk.services.datapipeline.model.RemoveTagsRequest;
import software.amazon.awssdk.services.datapipeline.model.RemoveTagsResponse;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressRequest;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressResponse;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatResponse;
import software.amazon.awssdk.services.datapipeline.model.SetStatusRequest;
import software.amazon.awssdk.services.datapipeline.model.SetStatusResponse;
import software.amazon.awssdk.services.datapipeline.model.SetTaskStatusRequest;
import software.amazon.awssdk.services.datapipeline.model.SetTaskStatusResponse;
import software.amazon.awssdk.services.datapipeline.model.TaskNotFoundException;
import software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionRequest;
import software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionResponse;
import software.amazon.awssdk.services.datapipeline.paginators.DescribeObjectsPaginator;
import software.amazon.awssdk.services.datapipeline.paginators.ListPipelinesPaginator;
import software.amazon.awssdk.services.datapipeline.paginators.QueryObjectsPaginator;
import software.amazon.awssdk.services.datapipeline.transform.ActivatePipelineRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ActivatePipelineResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.AddTagsResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.CreatePipelineResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DeactivatePipelineRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DeactivatePipelineResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DeletePipelineResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DescribeObjectsRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DescribeObjectsResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DescribePipelinesRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DescribePipelinesResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.EvaluateExpressionRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.EvaluateExpressionResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.GetPipelineDefinitionRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.GetPipelineDefinitionResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ListPipelinesResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.PollForTaskRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.PollForTaskResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.PutPipelineDefinitionRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.PutPipelineDefinitionResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.QueryObjectsRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.QueryObjectsResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.RemoveTagsResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ReportTaskProgressRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ReportTaskProgressResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ReportTaskRunnerHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ReportTaskRunnerHeartbeatResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.SetStatusRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.SetStatusResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.SetTaskStatusRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.SetTaskStatusResponseUnmarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ValidatePipelineDefinitionRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ValidatePipelineDefinitionResponseUnmarshaller;

@SdkInternalApi
final class DefaultDataPipelineClient
implements DataPipelineClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultDataPipelineClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "datapipeline";
    }

    @Override
    public ActivatePipelineResponse activatePipeline(ActivatePipelineRequest activatePipelineRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ActivatePipelineResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ActivatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)activatePipelineRequest).withMarshaller((Marshaller)new ActivatePipelineRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsRequest).withMarshaller((Marshaller)new AddTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws InternalServiceErrorException, InvalidRequestException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePipelineResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPipelineRequest).withMarshaller((Marshaller)new CreatePipelineRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeactivatePipelineResponse deactivatePipeline(DeactivatePipelineRequest deactivatePipelineRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeactivatePipelineResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeactivatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deactivatePipelineRequest).withMarshaller((Marshaller)new DeactivatePipelineRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws PipelineNotFoundException, InternalServiceErrorException, InvalidRequestException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePipelineResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeletePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePipelineRequest).withMarshaller((Marshaller)new DeletePipelineRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeObjectsResponse describeObjects(DescribeObjectsRequest describeObjectsRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeObjectsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeObjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeObjectsRequest).withMarshaller((Marshaller)new DescribeObjectsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeObjectsPaginator describeObjectsIterable(DescribeObjectsRequest describeObjectsRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkServiceException, SdkClientException, DataPipelineException {
        return new DescribeObjectsPaginator(this, describeObjectsRequest);
    }

    @Override
    public DescribePipelinesResponse describePipelines(DescribePipelinesRequest describePipelinesRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribePipelinesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribePipelinesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePipelinesRequest).withMarshaller((Marshaller)new DescribePipelinesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public EvaluateExpressionResponse evaluateExpression(EvaluateExpressionRequest evaluateExpressionRequest) throws InternalServiceErrorException, TaskNotFoundException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EvaluateExpressionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (EvaluateExpressionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)evaluateExpressionRequest).withMarshaller((Marshaller)new EvaluateExpressionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetPipelineDefinitionResponse getPipelineDefinition(GetPipelineDefinitionRequest getPipelineDefinitionRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPipelineDefinitionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetPipelineDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPipelineDefinitionRequest).withMarshaller((Marshaller)new GetPipelineDefinitionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws InternalServiceErrorException, InvalidRequestException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPipelinesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListPipelinesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPipelinesRequest).withMarshaller((Marshaller)new ListPipelinesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListPipelinesPaginator listPipelinesIterable(ListPipelinesRequest listPipelinesRequest) throws InternalServiceErrorException, InvalidRequestException, SdkServiceException, SdkClientException, DataPipelineException {
        return new ListPipelinesPaginator(this, listPipelinesRequest);
    }

    @Override
    public PollForTaskResponse pollForTask(PollForTaskRequest pollForTaskRequest) throws InternalServiceErrorException, InvalidRequestException, TaskNotFoundException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PollForTaskResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PollForTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)pollForTaskRequest).withMarshaller((Marshaller)new PollForTaskRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutPipelineDefinitionResponse putPipelineDefinition(PutPipelineDefinitionRequest putPipelineDefinitionRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutPipelineDefinitionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PutPipelineDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putPipelineDefinitionRequest).withMarshaller((Marshaller)new PutPipelineDefinitionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public QueryObjectsResponse queryObjects(QueryObjectsRequest queryObjectsRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new QueryObjectsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (QueryObjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)queryObjectsRequest).withMarshaller((Marshaller)new QueryObjectsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public QueryObjectsPaginator queryObjectsIterable(QueryObjectsRequest queryObjectsRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, SdkServiceException, SdkClientException, DataPipelineException {
        return new QueryObjectsPaginator(this, queryObjectsRequest);
    }

    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveTagsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RemoveTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsRequest).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ReportTaskProgressResponse reportTaskProgress(ReportTaskProgressRequest reportTaskProgressRequest) throws InternalServiceErrorException, InvalidRequestException, TaskNotFoundException, PipelineNotFoundException, PipelineDeletedException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ReportTaskProgressResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ReportTaskProgressResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)reportTaskProgressRequest).withMarshaller((Marshaller)new ReportTaskProgressRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ReportTaskRunnerHeartbeatResponse reportTaskRunnerHeartbeat(ReportTaskRunnerHeartbeatRequest reportTaskRunnerHeartbeatRequest) throws InternalServiceErrorException, InvalidRequestException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ReportTaskRunnerHeartbeatResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ReportTaskRunnerHeartbeatResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)reportTaskRunnerHeartbeatRequest).withMarshaller((Marshaller)new ReportTaskRunnerHeartbeatRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetStatusResponse setStatus(SetStatusRequest setStatusRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetStatusResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SetStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setStatusRequest).withMarshaller((Marshaller)new SetStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetTaskStatusResponse setTaskStatus(SetTaskStatusRequest setTaskStatusRequest) throws InternalServiceErrorException, TaskNotFoundException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetTaskStatusResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SetTaskStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setTaskStatusRequest).withMarshaller((Marshaller)new SetTaskStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ValidatePipelineDefinitionResponse validatePipelineDefinition(ValidatePipelineDefinitionRequest validatePipelineDefinitionRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, SdkServiceException, SdkClientException, DataPipelineException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ValidatePipelineDefinitionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ValidatePipelineDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)validatePipelineDefinitionRequest).withMarshaller((Marshaller)new ValidatePipelineDefinitionRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<SdkServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(DataPipelineException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TaskNotFoundException").withModeledClass(TaskNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineDeletedException").withModeledClass(PipelineDeletedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineNotFoundException").withModeledClass(PipelineNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceError").withModeledClass(InternalServiceErrorException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

