/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.datapipeline.model._validationMessagesCopier;
import software.amazon.awssdk.services.datapipeline.transform.ValidationErrorMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidationError
implements StructuredPojo,
ToCopyableBuilder<Builder, ValidationError> {
    private final String id;
    private final List<String> errors;

    private ValidationError(BuilderImpl builder) {
        this.id = builder.id;
        this.errors = builder.errors;
    }

    public String id() {
        return this.id;
    }

    public List<String> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationError)) {
            return false;
        }
        ValidationError other = (ValidationError)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.errors() != null) {
            sb.append("Errors: ").append(this.errors()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "errors": {
                return Optional.of(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ValidationErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<String> errors;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationError model) {
            this.id(model.id);
            this.errors(model.errors);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<String> getErrors() {
            return this.errors;
        }

        @Override
        public final Builder errors(Collection<String> errors) {
            this.errors = _validationMessagesCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(String ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        public final void setErrors(Collection<String> errors) {
            this.errors = _validationMessagesCopier.copy(errors);
        }

        public ValidationError build() {
            return new ValidationError(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidationError> {
        public Builder id(String var1);

        public Builder errors(Collection<String> var1);

        public Builder errors(String ... var1);
    }
}

