/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.datapipeline.model.ParameterAttribute;
import software.amazon.awssdk.services.datapipeline.model.ParameterAttributeListCopier;
import software.amazon.awssdk.services.datapipeline.transform.ParameterObjectMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ParameterObject
implements StructuredPojo,
ToCopyableBuilder<Builder, ParameterObject> {
    private final String id;
    private final List<ParameterAttribute> attributes;

    private ParameterObject(BuilderImpl builder) {
        this.id = builder.id;
        this.attributes = builder.attributes;
    }

    public String id() {
        return this.id;
    }

    public List<ParameterAttribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterObject)) {
            return false;
        }
        ParameterObject other = (ParameterObject)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<ParameterAttribute> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterObject model) {
            this.id(model.id);
            this.attributes(model.attributes);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<ParameterAttribute.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(ParameterAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<ParameterAttribute> attributes) {
            this.attributes = ParameterAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(ParameterAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<ParameterAttribute.BuilderImpl> attributes) {
            this.attributes = ParameterAttributeListCopier.copyFromBuilder(attributes);
        }

        public ParameterObject build() {
            return new ParameterObject(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ParameterObject> {
        public Builder id(String var1);

        public Builder attributes(Collection<ParameterAttribute> var1);

        public Builder attributes(ParameterAttribute ... var1);
    }
}

