/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.datapipeline.model._idListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetStatusRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetStatusRequest> {
    private final String pipelineId;
    private final List<String> objectIds;
    private final String status;

    private SetStatusRequest(BuilderImpl builder) {
        this.pipelineId = builder.pipelineId;
        this.objectIds = builder.objectIds;
        this.status = builder.status;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public List<String> objectIds() {
        return this.objectIds;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineId() == null ? 0 : this.pipelineId().hashCode());
        hashCode = 31 * hashCode + (this.objectIds() == null ? 0 : this.objectIds().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetStatusRequest)) {
            return false;
        }
        SetStatusRequest other = (SetStatusRequest)((Object)obj);
        if (other.pipelineId() == null ^ this.pipelineId() == null) {
            return false;
        }
        if (other.pipelineId() != null && !other.pipelineId().equals(this.pipelineId())) {
            return false;
        }
        if (other.objectIds() == null ^ this.objectIds() == null) {
            return false;
        }
        if (other.objectIds() != null && !other.objectIds().equals(this.objectIds())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineId() != null) {
            sb.append("PipelineId: ").append(this.pipelineId()).append(",");
        }
        if (this.objectIds() != null) {
            sb.append("ObjectIds: ").append(this.objectIds()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.of(clazz.cast(this.pipelineId()));
            }
            case "objectIds": {
                return Optional.of(clazz.cast(this.objectIds()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineId;
        private List<String> objectIds;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SetStatusRequest model) {
            this.pipelineId(model.pipelineId);
            this.objectIds(model.objectIds);
            this.status(model.status);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Collection<String> getObjectIds() {
            return this.objectIds;
        }

        @Override
        public final Builder objectIds(Collection<String> objectIds) {
            this.objectIds = _idListCopier.copy(objectIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIds(String ... objectIds) {
            this.objectIds(Arrays.asList(objectIds));
            return this;
        }

        public final void setObjectIds(Collection<String> objectIds) {
            this.objectIds = _idListCopier.copy(objectIds);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public SetStatusRequest build() {
            return new SetStatusRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetStatusRequest> {
        public Builder pipelineId(String var1);

        public Builder objectIds(Collection<String> var1);

        public Builder objectIds(String ... var1);

        public Builder status(String var1);
    }
}

