/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.datapipeline.model.Selector;
import software.amazon.awssdk.services.datapipeline.model.SelectorListCopier;
import software.amazon.awssdk.services.datapipeline.transform.QueryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Query
implements StructuredPojo,
ToCopyableBuilder<Builder, Query> {
    private final List<Selector> selectors;

    private Query(BuilderImpl builder) {
        this.selectors = builder.selectors;
    }

    public List<Selector> selectors() {
        return this.selectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.selectors() == null ? 0 : this.selectors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query)obj;
        if (other.selectors() == null ^ this.selectors() == null) {
            return false;
        }
        return other.selectors() == null || other.selectors().equals(this.selectors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.selectors() != null) {
            sb.append("Selectors: ").append(this.selectors()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "selectors": {
                return Optional.of(clazz.cast(this.selectors()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Selector> selectors;

        private BuilderImpl() {
        }

        private BuilderImpl(Query model) {
            this.selectors(model.selectors);
        }

        public final Collection<Selector.Builder> getSelectors() {
            return this.selectors != null ? (Collection)this.selectors.stream().map(Selector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder selectors(Collection<Selector> selectors) {
            this.selectors = SelectorListCopier.copy(selectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Selector ... selectors) {
            this.selectors(Arrays.asList(selectors));
            return this;
        }

        public final void setSelectors(Collection<Selector.BuilderImpl> selectors) {
            this.selectors = SelectorListCopier.copyFromBuilder(selectors);
        }

        public Query build() {
            return new Query(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Query> {
        public Builder selectors(Collection<Selector> var1);

        public Builder selectors(Selector ... var1);
    }
}

