/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.datapipeline.transform.FieldMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Field
implements StructuredPojo,
ToCopyableBuilder<Builder, Field> {
    private final String key;
    private final String stringValue;
    private final String refValue;

    private Field(BuilderImpl builder) {
        this.key = builder.key;
        this.stringValue = builder.stringValue;
        this.refValue = builder.refValue;
    }

    public String key() {
        return this.key;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public String refValue() {
        return this.refValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.stringValue() == null ? 0 : this.stringValue().hashCode());
        hashCode = 31 * hashCode + (this.refValue() == null ? 0 : this.refValue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field)obj;
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.stringValue() == null ^ this.stringValue() == null) {
            return false;
        }
        if (other.stringValue() != null && !other.stringValue().equals(this.stringValue())) {
            return false;
        }
        if (other.refValue() == null ^ this.refValue() == null) {
            return false;
        }
        return other.refValue() == null || other.refValue().equals(this.refValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.stringValue() != null) {
            sb.append("StringValue: ").append(this.stringValue()).append(",");
        }
        if (this.refValue() != null) {
            sb.append("RefValue: ").append(this.refValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "stringValue": {
                return Optional.of(clazz.cast(this.stringValue()));
            }
            case "refValue": {
                return Optional.of(clazz.cast(this.refValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FieldMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String stringValue;
        private String refValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Field model) {
            this.key(model.key);
            this.stringValue(model.stringValue);
            this.refValue(model.refValue);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final String getRefValue() {
            return this.refValue;
        }

        @Override
        public final Builder refValue(String refValue) {
            this.refValue = refValue;
            return this;
        }

        public final void setRefValue(String refValue) {
            this.refValue = refValue;
        }

        public Field build() {
            return new Field(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Field> {
        public Builder key(String var1);

        public Builder stringValue(String var1);

        public Builder refValue(String var1);
    }
}

