/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.datapipeline.model.PipelineObject;
import software.amazon.awssdk.services.datapipeline.model.PipelineObjectListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeObjectsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeObjectsResponse> {
    private final List<PipelineObject> pipelineObjects;
    private final String marker;
    private final Boolean hasMoreResults;

    private DescribeObjectsResponse(BuilderImpl builder) {
        this.pipelineObjects = builder.pipelineObjects;
        this.marker = builder.marker;
        this.hasMoreResults = builder.hasMoreResults;
    }

    public List<PipelineObject> pipelineObjects() {
        return this.pipelineObjects;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean hasMoreResults() {
        return this.hasMoreResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineObjects() == null ? 0 : this.pipelineObjects().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.hasMoreResults() == null ? 0 : this.hasMoreResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeObjectsResponse)) {
            return false;
        }
        DescribeObjectsResponse other = (DescribeObjectsResponse)((Object)obj);
        if (other.pipelineObjects() == null ^ this.pipelineObjects() == null) {
            return false;
        }
        if (other.pipelineObjects() != null && !other.pipelineObjects().equals(this.pipelineObjects())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.hasMoreResults() == null ^ this.hasMoreResults() == null) {
            return false;
        }
        return other.hasMoreResults() == null || other.hasMoreResults().equals(this.hasMoreResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineObjects() != null) {
            sb.append("PipelineObjects: ").append(this.pipelineObjects()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.hasMoreResults() != null) {
            sb.append("HasMoreResults: ").append(this.hasMoreResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineObjects": {
                return Optional.of(clazz.cast(this.pipelineObjects()));
            }
            case "marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "hasMoreResults": {
                return Optional.of(clazz.cast(this.hasMoreResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<PipelineObject> pipelineObjects;
        private String marker;
        private Boolean hasMoreResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeObjectsResponse model) {
            this.pipelineObjects(model.pipelineObjects);
            this.marker(model.marker);
            this.hasMoreResults(model.hasMoreResults);
        }

        public final Collection<PipelineObject.Builder> getPipelineObjects() {
            return this.pipelineObjects != null ? (Collection)this.pipelineObjects.stream().map(PipelineObject::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelineObjects(Collection<PipelineObject> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copy(pipelineObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(PipelineObject ... pipelineObjects) {
            this.pipelineObjects(Arrays.asList(pipelineObjects));
            return this;
        }

        public final void setPipelineObjects(Collection<PipelineObject.BuilderImpl> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copyFromBuilder(pipelineObjects);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getHasMoreResults() {
            return this.hasMoreResults;
        }

        @Override
        public final Builder hasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
            return this;
        }

        public final void setHasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
        }

        public DescribeObjectsResponse build() {
            return new DescribeObjectsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeObjectsResponse> {
        public Builder pipelineObjects(Collection<PipelineObject> var1);

        public Builder pipelineObjects(PipelineObject ... var1);

        public Builder marker(String var1);

        public Builder hasMoreResults(Boolean var1);
    }
}

