/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.datapipeline.model._idListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeObjectsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeObjectsRequest> {
    private final String pipelineId;
    private final List<String> objectIds;
    private final Boolean evaluateExpressions;
    private final String marker;

    private DescribeObjectsRequest(BuilderImpl builder) {
        this.pipelineId = builder.pipelineId;
        this.objectIds = builder.objectIds;
        this.evaluateExpressions = builder.evaluateExpressions;
        this.marker = builder.marker;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public List<String> objectIds() {
        return this.objectIds;
    }

    public Boolean evaluateExpressions() {
        return this.evaluateExpressions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineId() == null ? 0 : this.pipelineId().hashCode());
        hashCode = 31 * hashCode + (this.objectIds() == null ? 0 : this.objectIds().hashCode());
        hashCode = 31 * hashCode + (this.evaluateExpressions() == null ? 0 : this.evaluateExpressions().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeObjectsRequest)) {
            return false;
        }
        DescribeObjectsRequest other = (DescribeObjectsRequest)((Object)obj);
        if (other.pipelineId() == null ^ this.pipelineId() == null) {
            return false;
        }
        if (other.pipelineId() != null && !other.pipelineId().equals(this.pipelineId())) {
            return false;
        }
        if (other.objectIds() == null ^ this.objectIds() == null) {
            return false;
        }
        if (other.objectIds() != null && !other.objectIds().equals(this.objectIds())) {
            return false;
        }
        if (other.evaluateExpressions() == null ^ this.evaluateExpressions() == null) {
            return false;
        }
        if (other.evaluateExpressions() != null && !other.evaluateExpressions().equals(this.evaluateExpressions())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineId() != null) {
            sb.append("PipelineId: ").append(this.pipelineId()).append(",");
        }
        if (this.objectIds() != null) {
            sb.append("ObjectIds: ").append(this.objectIds()).append(",");
        }
        if (this.evaluateExpressions() != null) {
            sb.append("EvaluateExpressions: ").append(this.evaluateExpressions()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.of(clazz.cast(this.pipelineId()));
            }
            case "objectIds": {
                return Optional.of(clazz.cast(this.objectIds()));
            }
            case "evaluateExpressions": {
                return Optional.of(clazz.cast(this.evaluateExpressions()));
            }
            case "marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineId;
        private List<String> objectIds;
        private Boolean evaluateExpressions;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeObjectsRequest model) {
            this.pipelineId(model.pipelineId);
            this.objectIds(model.objectIds);
            this.evaluateExpressions(model.evaluateExpressions);
            this.marker(model.marker);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Collection<String> getObjectIds() {
            return this.objectIds;
        }

        @Override
        public final Builder objectIds(Collection<String> objectIds) {
            this.objectIds = _idListCopier.copy(objectIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIds(String ... objectIds) {
            this.objectIds(Arrays.asList(objectIds));
            return this;
        }

        public final void setObjectIds(Collection<String> objectIds) {
            this.objectIds = _idListCopier.copy(objectIds);
        }

        public final Boolean getEvaluateExpressions() {
            return this.evaluateExpressions;
        }

        @Override
        public final Builder evaluateExpressions(Boolean evaluateExpressions) {
            this.evaluateExpressions = evaluateExpressions;
            return this;
        }

        public final void setEvaluateExpressions(Boolean evaluateExpressions) {
            this.evaluateExpressions = evaluateExpressions;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeObjectsRequest build() {
            return new DescribeObjectsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeObjectsRequest> {
        public Builder pipelineId(String var1);

        public Builder objectIds(Collection<String> var1);

        public Builder objectIds(String ... var1);

        public Builder evaluateExpressions(Boolean var1);

        public Builder marker(String var1);
    }
}

