/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.datapipeline.model.Selector;
import software.amazon.awssdk.services.datapipeline.transform.OperatorUnmarshaller;

public class SelectorUnmarshaller
implements Unmarshaller<Selector, JsonUnmarshallerContext> {
    private static final SelectorUnmarshaller INSTANCE = new SelectorUnmarshaller();

    public Selector unmarshall(JsonUnmarshallerContext context) throws Exception {
        Selector.Builder selectorBuilder = Selector.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("fieldName", targetDepth)) {
                    context.nextToken();
                    selectorBuilder.fieldName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("operator", targetDepth)) {
                    context.nextToken();
                    selectorBuilder.operator(OperatorUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Selector)selectorBuilder.build();
    }

    public static SelectorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

