/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.datapipeline.model._idListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QueryObjectsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, QueryObjectsResponse> {
    private final List<String> ids;
    private final String marker;
    private final Boolean hasMoreResults;

    private QueryObjectsResponse(BuilderImpl builder) {
        this.ids = builder.ids;
        this.marker = builder.marker;
        this.hasMoreResults = builder.hasMoreResults;
    }

    public List<String> ids() {
        return this.ids;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean hasMoreResults() {
        return this.hasMoreResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ids() == null ? 0 : this.ids().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.hasMoreResults() == null ? 0 : this.hasMoreResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryObjectsResponse)) {
            return false;
        }
        QueryObjectsResponse other = (QueryObjectsResponse)((Object)obj);
        if (other.ids() == null ^ this.ids() == null) {
            return false;
        }
        if (other.ids() != null && !other.ids().equals(this.ids())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.hasMoreResults() == null ^ this.hasMoreResults() == null) {
            return false;
        }
        return other.hasMoreResults() == null || other.hasMoreResults().equals(this.hasMoreResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ids() != null) {
            sb.append("Ids: ").append(this.ids()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.hasMoreResults() != null) {
            sb.append("HasMoreResults: ").append(this.hasMoreResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> ids;
        private String marker;
        private Boolean hasMoreResults;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryObjectsResponse model) {
            this.setIds(model.ids);
            this.setMarker(model.marker);
            this.setHasMoreResults(model.hasMoreResults);
        }

        public final Collection<String> getIds() {
            return this.ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = _idListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String ... ids) {
            this.ids(Arrays.asList(ids));
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = _idListCopier.copy(ids);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getHasMoreResults() {
            return this.hasMoreResults;
        }

        @Override
        public final Builder hasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
            return this;
        }

        public final void setHasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
        }

        public QueryObjectsResponse build() {
            return new QueryObjectsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QueryObjectsResponse> {
        public Builder ids(Collection<String> var1);

        public Builder ids(String ... var1);

        public Builder marker(String var1);

        public Builder hasMoreResults(Boolean var1);
    }
}

