/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.datapipeline.model.TaskObject;

@SdkInternalApi
public class TaskObjectMarshaller {
    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskId").build();
    private static final MarshallingInfo<String> PIPELINEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineId").build();
    private static final MarshallingInfo<String> ATTEMPTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attemptId").build();
    private static final MarshallingInfo<Map> OBJECTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objects").build();
    private static final TaskObjectMarshaller INSTANCE = new TaskObjectMarshaller();

    public static TaskObjectMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TaskObject taskObject, ProtocolMarshaller protocolMarshaller) {
        if (taskObject == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)taskObject.taskId(), TASKID_BINDING);
            protocolMarshaller.marshall((Object)taskObject.pipelineId(), PIPELINEID_BINDING);
            protocolMarshaller.marshall((Object)taskObject.attemptId(), ATTEMPTID_BINDING);
            protocolMarshaller.marshall(taskObject.objects(), OBJECTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

