/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.datapipeline.model.TaskObject;
import software.amazon.awssdk.services.datapipeline.transform.PipelineObjectUnmarshaller;

public class TaskObjectUnmarshaller
implements Unmarshaller<TaskObject, JsonUnmarshallerContext> {
    private static final TaskObjectUnmarshaller INSTANCE = new TaskObjectUnmarshaller();

    public TaskObject unmarshall(JsonUnmarshallerContext context) throws Exception {
        TaskObject.Builder taskObjectBuilder = TaskObject.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("taskId", targetDepth)) {
                    context.nextToken();
                    taskObjectBuilder.taskId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("pipelineId", targetDepth)) {
                    context.nextToken();
                    taskObjectBuilder.pipelineId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("attemptId", targetDepth)) {
                    context.nextToken();
                    taskObjectBuilder.attemptId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("objects", targetDepth)) {
                    context.nextToken();
                    taskObjectBuilder.objects(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)PipelineObjectUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TaskObject)taskObjectBuilder.build();
    }

    public static TaskObjectUnmarshaller getInstance() {
        return INSTANCE;
    }
}

