/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.datapipeline.model.InstanceIdentity;

@SdkInternalApi
public class InstanceIdentityMarshaller {
    private static final MarshallingInfo<String> DOCUMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("document").build();
    private static final MarshallingInfo<String> SIGNATURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signature").build();
    private static final InstanceIdentityMarshaller instance = new InstanceIdentityMarshaller();

    public static InstanceIdentityMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstanceIdentity instanceIdentity, ProtocolMarshaller protocolMarshaller) {
        if (instanceIdentity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceIdentity.document(), DOCUMENT_BINDING);
            protocolMarshaller.marshall((Object)instanceIdentity.signature(), SIGNATURE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

