/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.datapipeline.model.ValidationError;
import software.amazon.awssdk.services.datapipeline.model.ValidationErrorsCopier;
import software.amazon.awssdk.services.datapipeline.model.ValidationWarning;
import software.amazon.awssdk.services.datapipeline.model.ValidationWarningsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidatePipelineDefinitionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ValidatePipelineDefinitionResponse> {
    private final List<ValidationError> validationErrors;
    private final List<ValidationWarning> validationWarnings;
    private final Boolean errored;

    private ValidatePipelineDefinitionResponse(BuilderImpl builder) {
        this.validationErrors = builder.validationErrors;
        this.validationWarnings = builder.validationWarnings;
        this.errored = builder.errored;
    }

    public List<ValidationError> validationErrors() {
        return this.validationErrors;
    }

    public List<ValidationWarning> validationWarnings() {
        return this.validationWarnings;
    }

    public Boolean errored() {
        return this.errored;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.validationErrors() == null ? 0 : this.validationErrors().hashCode());
        hashCode = 31 * hashCode + (this.validationWarnings() == null ? 0 : this.validationWarnings().hashCode());
        hashCode = 31 * hashCode + (this.errored() == null ? 0 : this.errored().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePipelineDefinitionResponse)) {
            return false;
        }
        ValidatePipelineDefinitionResponse other = (ValidatePipelineDefinitionResponse)((Object)obj);
        if (other.validationErrors() == null ^ this.validationErrors() == null) {
            return false;
        }
        if (other.validationErrors() != null && !other.validationErrors().equals(this.validationErrors())) {
            return false;
        }
        if (other.validationWarnings() == null ^ this.validationWarnings() == null) {
            return false;
        }
        if (other.validationWarnings() != null && !other.validationWarnings().equals(this.validationWarnings())) {
            return false;
        }
        if (other.errored() == null ^ this.errored() == null) {
            return false;
        }
        return other.errored() == null || other.errored().equals(this.errored());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.validationErrors() != null) {
            sb.append("ValidationErrors: ").append(this.validationErrors()).append(",");
        }
        if (this.validationWarnings() != null) {
            sb.append("ValidationWarnings: ").append(this.validationWarnings()).append(",");
        }
        if (this.errored() != null) {
            sb.append("Errored: ").append(this.errored()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ValidationError> validationErrors;
        private List<ValidationWarning> validationWarnings;
        private Boolean errored;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidatePipelineDefinitionResponse model) {
            this.setValidationErrors(model.validationErrors);
            this.setValidationWarnings(model.validationWarnings);
            this.setErrored(model.errored);
        }

        public final Collection<ValidationError> getValidationErrors() {
            return this.validationErrors;
        }

        @Override
        public final Builder validationErrors(Collection<ValidationError> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(ValidationError ... validationErrors) {
            this.validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        public final void setValidationErrors(Collection<ValidationError> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copy(validationErrors);
        }

        @SafeVarargs
        public final void setValidationErrors(ValidationError ... validationErrors) {
            this.validationErrors(Arrays.asList(validationErrors));
        }

        public final Collection<ValidationWarning> getValidationWarnings() {
            return this.validationWarnings;
        }

        @Override
        public final Builder validationWarnings(Collection<ValidationWarning> validationWarnings) {
            this.validationWarnings = ValidationWarningsCopier.copy(validationWarnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationWarnings(ValidationWarning ... validationWarnings) {
            this.validationWarnings(Arrays.asList(validationWarnings));
            return this;
        }

        public final void setValidationWarnings(Collection<ValidationWarning> validationWarnings) {
            this.validationWarnings = ValidationWarningsCopier.copy(validationWarnings);
        }

        @SafeVarargs
        public final void setValidationWarnings(ValidationWarning ... validationWarnings) {
            this.validationWarnings(Arrays.asList(validationWarnings));
        }

        public final Boolean getErrored() {
            return this.errored;
        }

        @Override
        public final Builder errored(Boolean errored) {
            this.errored = errored;
            return this;
        }

        public final void setErrored(Boolean errored) {
            this.errored = errored;
        }

        public ValidatePipelineDefinitionResponse build() {
            return new ValidatePipelineDefinitionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidatePipelineDefinitionResponse> {
        public Builder validationErrors(Collection<ValidationError> var1);

        public Builder validationErrors(ValidationError ... var1);

        public Builder validationWarnings(Collection<ValidationWarning> var1);

        public Builder validationWarnings(ValidationWarning ... var1);

        public Builder errored(Boolean var1);
    }
}

