/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.datapipeline.model.ParameterObject;
import software.amazon.awssdk.services.datapipeline.model.ParameterObjectListCopier;
import software.amazon.awssdk.services.datapipeline.model.ParameterValue;
import software.amazon.awssdk.services.datapipeline.model.ParameterValueListCopier;
import software.amazon.awssdk.services.datapipeline.model.PipelineObject;
import software.amazon.awssdk.services.datapipeline.model.PipelineObjectListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutPipelineDefinitionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutPipelineDefinitionRequest> {
    private final String pipelineId;
    private final List<PipelineObject> pipelineObjects;
    private final List<ParameterObject> parameterObjects;
    private final List<ParameterValue> parameterValues;

    private PutPipelineDefinitionRequest(BuilderImpl builder) {
        this.pipelineId = builder.pipelineId;
        this.pipelineObjects = builder.pipelineObjects;
        this.parameterObjects = builder.parameterObjects;
        this.parameterValues = builder.parameterValues;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public List<PipelineObject> pipelineObjects() {
        return this.pipelineObjects;
    }

    public List<ParameterObject> parameterObjects() {
        return this.parameterObjects;
    }

    public List<ParameterValue> parameterValues() {
        return this.parameterValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineId() == null ? 0 : this.pipelineId().hashCode());
        hashCode = 31 * hashCode + (this.pipelineObjects() == null ? 0 : this.pipelineObjects().hashCode());
        hashCode = 31 * hashCode + (this.parameterObjects() == null ? 0 : this.parameterObjects().hashCode());
        hashCode = 31 * hashCode + (this.parameterValues() == null ? 0 : this.parameterValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPipelineDefinitionRequest)) {
            return false;
        }
        PutPipelineDefinitionRequest other = (PutPipelineDefinitionRequest)((Object)obj);
        if (other.pipelineId() == null ^ this.pipelineId() == null) {
            return false;
        }
        if (other.pipelineId() != null && !other.pipelineId().equals(this.pipelineId())) {
            return false;
        }
        if (other.pipelineObjects() == null ^ this.pipelineObjects() == null) {
            return false;
        }
        if (other.pipelineObjects() != null && !other.pipelineObjects().equals(this.pipelineObjects())) {
            return false;
        }
        if (other.parameterObjects() == null ^ this.parameterObjects() == null) {
            return false;
        }
        if (other.parameterObjects() != null && !other.parameterObjects().equals(this.parameterObjects())) {
            return false;
        }
        if (other.parameterValues() == null ^ this.parameterValues() == null) {
            return false;
        }
        return other.parameterValues() == null || other.parameterValues().equals(this.parameterValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pipelineId() != null) {
            sb.append("PipelineId: ").append(this.pipelineId()).append(",");
        }
        if (this.pipelineObjects() != null) {
            sb.append("PipelineObjects: ").append(this.pipelineObjects()).append(",");
        }
        if (this.parameterObjects() != null) {
            sb.append("ParameterObjects: ").append(this.parameterObjects()).append(",");
        }
        if (this.parameterValues() != null) {
            sb.append("ParameterValues: ").append(this.parameterValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String pipelineId;
        private List<PipelineObject> pipelineObjects;
        private List<ParameterObject> parameterObjects;
        private List<ParameterValue> parameterValues;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPipelineDefinitionRequest model) {
            this.setPipelineId(model.pipelineId);
            this.setPipelineObjects(model.pipelineObjects);
            this.setParameterObjects(model.parameterObjects);
            this.setParameterValues(model.parameterValues);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Collection<PipelineObject> getPipelineObjects() {
            return this.pipelineObjects;
        }

        @Override
        public final Builder pipelineObjects(Collection<PipelineObject> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copy(pipelineObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(PipelineObject ... pipelineObjects) {
            this.pipelineObjects(Arrays.asList(pipelineObjects));
            return this;
        }

        public final void setPipelineObjects(Collection<PipelineObject> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copy(pipelineObjects);
        }

        @SafeVarargs
        public final void setPipelineObjects(PipelineObject ... pipelineObjects) {
            this.pipelineObjects(Arrays.asList(pipelineObjects));
        }

        public final Collection<ParameterObject> getParameterObjects() {
            return this.parameterObjects;
        }

        @Override
        public final Builder parameterObjects(Collection<ParameterObject> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copy(parameterObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterObjects(ParameterObject ... parameterObjects) {
            this.parameterObjects(Arrays.asList(parameterObjects));
            return this;
        }

        public final void setParameterObjects(Collection<ParameterObject> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copy(parameterObjects);
        }

        @SafeVarargs
        public final void setParameterObjects(ParameterObject ... parameterObjects) {
            this.parameterObjects(Arrays.asList(parameterObjects));
        }

        public final Collection<ParameterValue> getParameterValues() {
            return this.parameterValues;
        }

        @Override
        public final Builder parameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(ParameterValue ... parameterValues) {
            this.parameterValues(Arrays.asList(parameterValues));
            return this;
        }

        public final void setParameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
        }

        @SafeVarargs
        public final void setParameterValues(ParameterValue ... parameterValues) {
            this.parameterValues(Arrays.asList(parameterValues));
        }

        public PutPipelineDefinitionRequest build() {
            return new PutPipelineDefinitionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutPipelineDefinitionRequest> {
        public Builder pipelineId(String var1);

        public Builder pipelineObjects(Collection<PipelineObject> var1);

        public Builder pipelineObjects(PipelineObject ... var1);

        public Builder parameterObjects(Collection<ParameterObject> var1);

        public Builder parameterObjects(ParameterObject ... var1);

        public Builder parameterValues(Collection<ParameterValue> var1);

        public Builder parameterValues(ParameterValue ... var1);
    }
}

