/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.datapipeline.transform.InstanceIdentityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceIdentity
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceIdentity> {
    private final String document;
    private final String signature;

    private InstanceIdentity(BuilderImpl builder) {
        this.document = builder.document;
        this.signature = builder.signature;
    }

    public String document() {
        return this.document;
    }

    public String signature() {
        return this.signature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.document() == null ? 0 : this.document().hashCode());
        hashCode = 31 * hashCode + (this.signature() == null ? 0 : this.signature().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceIdentity)) {
            return false;
        }
        InstanceIdentity other = (InstanceIdentity)obj;
        if (other.document() == null ^ this.document() == null) {
            return false;
        }
        if (other.document() != null && !other.document().equals(this.document())) {
            return false;
        }
        if (other.signature() == null ^ this.signature() == null) {
            return false;
        }
        return other.signature() == null || other.signature().equals(this.signature());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.document() != null) {
            sb.append("Document: ").append(this.document()).append(",");
        }
        if (this.signature() != null) {
            sb.append("Signature: ").append(this.signature()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceIdentityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String document;
        private String signature;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceIdentity model) {
            this.setDocument(model.document);
            this.setSignature(model.signature);
        }

        public final String getDocument() {
            return this.document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        public final String getSignature() {
            return this.signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public InstanceIdentity build() {
            return new InstanceIdentity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceIdentity> {
        public Builder document(String var1);

        public Builder signature(String var1);
    }
}

