/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.datapipeline.model.ValidationError;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ValidationErrorMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<List> ERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errors").isBinary(false).build();
    private static final ValidationErrorMarshaller INSTANCE = new ValidationErrorMarshaller();

    private ValidationErrorMarshaller() {
    }

    public static ValidationErrorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ValidationError validationError, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)validationError, (String)"validationError");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)validationError.id(), ID_BINDING);
            protocolMarshaller.marshall(validationError.errors(), ERRORS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

