/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.datapipeline.model.ParameterAttribute;

public class ParameterAttributeUnmarshaller
implements Unmarshaller<ParameterAttribute, JsonUnmarshallerContext> {
    private static final ParameterAttributeUnmarshaller INSTANCE = new ParameterAttributeUnmarshaller();

    public ParameterAttribute unmarshall(JsonUnmarshallerContext context) throws Exception {
        ParameterAttribute.Builder parameterAttributeBuilder = ParameterAttribute.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("key", targetDepth)) {
                    context.nextToken();
                    parameterAttributeBuilder.key((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("stringValue", targetDepth)) {
                    context.nextToken();
                    parameterAttributeBuilder.stringValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ParameterAttribute)parameterAttributeBuilder.build();
    }

    public static ParameterAttributeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

